/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.pages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.serenitybdd.core.pages.PageObject;
import net.serenitybdd.core.pages.WebElementFacade;
import org.openqa.selenium.StaleElementReferenceException;

public class ListOfWebElementFacades
extends ArrayList<WebElementFacade> {
    private Function<PageObject, ListOfWebElementFacades> fallback;
    private PageObject page;

    public ListOfWebElementFacades(Collection<? extends WebElementFacade> c) {
        super(c);
    }

    public List<String> texts() {
        return this.map(WebElementFacade::getText);
    }

    public List<String> textContents() {
        return this.map(WebElementFacade::getTextContent);
    }

    public <T> List<T> map(Function<? super WebElementFacade, T> elementConverter) {
        return this.convert(list -> list.stream().map(elementConverter).collect(Collectors.toList()));
    }

    public List<? super WebElementFacade> filter(Predicate<? super WebElementFacade> condition) {
        return this.convert(list -> list.stream().filter(condition).collect(Collectors.toList()));
    }

    public void setFallback(Function<PageObject, ListOfWebElementFacades> fallbackMethod, PageObject page) {
        this.fallback = fallbackMethod;
        this.page = page;
    }

    private <R> List<R> convert(Function<ListOfWebElementFacades, List<R>> transform) {
        try {
            return transform.apply(this);
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            if (this.fallback != null) {
                this.page.waitFor(1).second();
                return transform.apply(this.fallback.apply(this.page));
            }
            throw staleElementReferenceException;
        }
    }
}

