/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.webdriver;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.serenitybdd.core.pages.DefaultTimeouts;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.webdriver.ConfigurableTimeouts;
import net.thucydides.core.webdriver.SupportedWebDriver;
import net.thucydides.core.webdriver.WebDriverFacade;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.Duration;

public class WebdriverInstances {
    private final Map<String, WebDriver> driverMap = new HashMap<String, WebDriver>();
    private String currentDriver;
    private EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);

    public WebDriver getCurrentDriver() {
        if (this.driverMap.containsKey(this.currentDriver)) {
            return this.driverMap.get(this.currentDriver);
        }
        return null;
    }

    public String getCurrentDriverName() {
        if (this.getCurrentDriver() == null) {
            return "";
        }
        if (this.getCurrentDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getCurrentDriver()).getDriverName();
        }
        if (this.getCurrentDriver().getClass().getName().contains("Mockito")) {
            return SupportedWebDriver.forClass(this.getCurrentDriver().getClass().getSuperclass()).name().toLowerCase();
        }
        return "";
    }

    public WebDriver closeCurrentDriver() {
        WebDriver closedDriver = null;
        if (this.getCurrentDriver() != null) {
            closedDriver = this.getCurrentDriver();
            this.closeAndQuit(closedDriver);
            this.driverMap.remove(this.currentDriver);
            this.currentDriver = null;
        }
        return closedDriver;
    }

    private void closeAndQuit(WebDriver driver) {
        driver.quit();
    }

    public void resetCurrentDriver() {
        WebDriver driver;
        if (this.getCurrentDriver() != null && WebDriverFacade.class.isAssignableFrom((driver = this.getCurrentDriver()).getClass())) {
            ((WebDriverFacade)driver).reset();
        }
    }

    public boolean driverIsRegisteredFor(String driverName) {
        return this.driverMap.containsKey(this.normalized(driverName));
    }

    public WebDriver useDriver(String driverName) {
        this.currentDriver = this.normalized(driverName);
        return this.driverMap.get(this.currentDriver);
    }

    public Set<WebDriver> closeAllDrivers() {
        Collection<WebDriver> openDrivers = this.driverMap.values();
        HashSet<WebDriver> closedDrivers = new HashSet<WebDriver>(openDrivers);
        for (WebDriver driver : openDrivers) {
            this.closeAndQuit(driver);
        }
        this.driverMap.clear();
        this.currentDriver = null;
        return closedDrivers;
    }

    public int getActiveWebdriverCount() {
        return this.driverMap.size();
    }

    public boolean isDriverInstantiated() {
        if (this.getCurrentDriver() instanceof WebDriverFacade) {
            return ((WebDriverFacade)this.getCurrentDriver()).isInstantiated();
        }
        return this.getCurrentDriver() != null;
    }

    public Duration getCurrentImplicitTimeout() {
        if (this.getCurrentDriver() instanceof ConfigurableTimeouts) {
            return ((ConfigurableTimeouts)this.getCurrentDriver()).getCurrentImplicitTimeout();
        }
        return this.getDefaultImplicitTimeout();
    }

    protected Duration getDefaultImplicitTimeout() {
        Integer configuredTimeout = ThucydidesSystemProperty.WEBDRIVER_TIMEOUTS_IMPLICITLYWAIT.integerFrom(this.environmentVariables, -1);
        return configuredTimeout >= 0 ? new Duration((long)configuredTimeout.intValue(), TimeUnit.MILLISECONDS) : DefaultTimeouts.DEFAULT_IMPLICIT_WAIT_TIMEOUT;
    }

    public InstanceRegistration registerDriverCalled(String driverName) {
        return new InstanceRegistration(this.normalized(driverName));
    }

    private String normalized(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return "firefox";
        }
        return name.toLowerCase();
    }

    public final class InstanceRegistration {
        private final String driverName;

        public InstanceRegistration(String driverName) {
            this.driverName = WebdriverInstances.this.normalized(driverName);
        }

        public void forDriver(WebDriver driver) {
            WebdriverInstances.this.driverMap.put(WebdriverInstances.this.normalized(this.driverName), driver);
            WebdriverInstances.this.currentDriver = WebdriverInstances.this.normalized(this.driverName);
        }
    }
}

