/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import ch.lambdaj.Lambda;
import ch.lambdaj.function.convert.Converter;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.AbstractRequirementsTagProvider;
import net.thucydides.core.requirements.OverridableTagProvider;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.RequirementsTagProvider;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.requirements.model.Narrative;
import net.thucydides.core.requirements.model.NarrativeReader;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.NameConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileSystemRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final String DEFAULT_ROOT_DIRECTORY = "stories";
    private static final String FEATURES_ROOT_DIRECTORY = "features";
    private static final String DEFAULT_RESOURCE_DIRECTORY = "src/test/resources";
    private static final String WORKING_DIR = "user.dir";
    private static final List<Requirement> NO_REQUIREMENTS = Lists.newArrayList();
    private static final List<TestTag> NO_TEST_TAGS = Lists.newArrayList();
    public static final String STORY_EXTENSION = "story";
    public static final String FEATURE_EXTENSION = "feature";
    private final String rootDirectoryPath;
    private final NarrativeReader narrativeReader;
    private final int level;
    private List<Requirement> requirements;
    private Optional<String> configuredRelativeRootDirectory;
    private final Pattern WINDOWS_PATH = Pattern.compile("([a-zA-Z]:)?(\\\\[a-zA-Z0-9_-]+)+\\\\?");

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(FileSystemRequirementsTagProvider.defaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()), 0, environmentVariables);
    }

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables, String root) {
        this(root, 0, environmentVariables);
    }

    public FileSystemRequirementsTagProvider() {
        this(FileSystemRequirementsTagProvider.defaultRootDirectoryPathFrom((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get()));
    }

    public static String defaultRootDirectoryPathFrom(EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.isDefinedIn(environmentVariables)) {
            return ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.from(environmentVariables);
        }
        if (ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.isDefinedIn(environmentVariables)) {
            return ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(environmentVariables);
        }
        Optional<String> resourceDirectory = FileSystemRequirementsTagProvider.getResourceDirectory(environmentVariables);
        if (resourceDirectory.isPresent()) {
            String resourceDir = (String)resourceDirectory.get();
            if (new File(resourceDir, DEFAULT_ROOT_DIRECTORY).exists()) {
                return DEFAULT_ROOT_DIRECTORY;
            }
            if (new File(resourceDir, FEATURES_ROOT_DIRECTORY).exists()) {
                return FEATURES_ROOT_DIRECTORY;
            }
        }
        return DEFAULT_ROOT_DIRECTORY;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), level, (EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    private static String filePathFormOf(String rootDirectory) {
        if (rootDirectory.contains(".")) {
            return rootDirectory.replace(".", "/");
        }
        return rootDirectory;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        super(environmentVariables);
        this.rootDirectoryPath = rootDirectory;
        this.level = level;
        this.narrativeReader = NarrativeReader.forRootDirectory(rootDirectory).withRequirementTypes(this.getRequirementTypes());
    }

    public FileSystemRequirementsTagProvider(String rootDirectory) {
        this(rootDirectory, 0);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            try {
                HashSet allRequirements = Sets.newHashSet();
                Set<String> directoryPaths = this.getRootDirectoryPaths();
                for (String rootDirectoryPath : directoryPaths) {
                    File rootDirectory = new File(rootDirectoryPath);
                    if (!rootDirectory.exists()) continue;
                    allRequirements.addAll(this.loadCapabilitiesFrom(rootDirectory.listFiles(this.thatAreDirectories())));
                    allRequirements.addAll(this.loadStoriesFrom(rootDirectory.listFiles(this.thatAreStories())));
                }
                this.requirements = Lists.newArrayList((Iterable)allRequirements);
                Collections.sort(this.requirements);
            }
            catch (IOException e) {
                this.requirements = NO_REQUIREMENTS;
                throw new IllegalArgumentException("Could not load requirements from '" + this.rootDirectoryPath + "'", e);
            }
            if (this.level == 0) {
                this.requirements = this.addParentsTo(this.requirements);
            }
        }
        return this.requirements;
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements) {
        return this.addParentsTo(requirements, null);
    }

    private List<Requirement> addParentsTo(List<Requirement> requirements, String parent) {
        ArrayList augmentedRequirements = Lists.newArrayList();
        for (Requirement requirement : requirements) {
            List<Requirement> children = requirement.hasChildren() ? this.addParentsTo(requirement.getChildren(), requirement.getName()) : NO_REQUIREMENTS;
            augmentedRequirements.add(requirement.withParent(parent).withChildren(children));
        }
        return augmentedRequirements;
    }

    public Set<String> getRootDirectoryPaths() throws IOException {
        if (ThucydidesSystemProperty.THUCYDIDES_TEST_REQUIREMENTS_BASEDIR.isDefinedIn(this.environmentVariables)) {
            return this.getRootDirectoryFromRequirementsBaseDir().asSet();
        }
        Set<String> rootDirectoryOnClasspath = this.getRootDirectoryFromClasspath();
        if (!rootDirectoryOnClasspath.isEmpty()) {
            return rootDirectoryOnClasspath;
        }
        return this.getRootDirectoryFromWorkingDirectory();
    }

    private Set<String> getRootDirectoryFromClasspath() throws IOException {
        ArrayList<URL> resourceRoots;
        try {
            Enumeration<URL> requirementResources = this.getDirectoriesFrom(this.rootDirectoryPath);
            resourceRoots = Collections.list(requirementResources);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
        return this.restoreSpacesIn(resourceRoots);
    }

    private Set<String> restoreSpacesIn(List<URL> resourceRoots) {
        HashSet urlsWithRestoredSpaces = Sets.newHashSet();
        for (URL resourceRoot : resourceRoots) {
            urlsWithRestoredSpaces.add(this.withRestoredSpaces(resourceRoot.getPath()));
        }
        return urlsWithRestoredSpaces;
    }

    private String withRestoredSpaces(String path) {
        try {
            return URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return StringUtils.replace((String)path, (String)"%20", (String)" ");
        }
    }

    private Set<String> getRootDirectoryFromWorkingDirectory() throws IOException {
        return this.getRootDirectoryFromParentDir(System.getProperty(WORKING_DIR)).asSet();
    }

    private Optional<String> getRootDirectoryFromRequirementsBaseDir() {
        if (this.configuredRelativeRootDirectory == null) {
            this.configuredRelativeRootDirectory = this.getRootDirectoryFromParentDir(ThucydidesSystemProperty.THUCYDIDES_TEST_REQUIREMENTS_BASEDIR.from(this.environmentVariables, ""));
        }
        return this.configuredRelativeRootDirectory;
    }

    private Optional<String> getRootDirectoryFromParentDir(String parentDir) {
        File requirementsDirectory;
        File resourceDirectory = FileSystemRequirementsTagProvider.getResourceDirectory(this.environmentVariables).isPresent() ? new File(parentDir, (String)FileSystemRequirementsTagProvider.getResourceDirectory(this.environmentVariables).get()) : new File(parentDir);
        File file = requirementsDirectory = this.absolutePath(this.rootDirectoryPath) ? new File(this.rootDirectoryPath) : new File(resourceDirectory, this.rootDirectoryPath);
        if (!requirementsDirectory.exists()) {
            requirementsDirectory = new File(resourceDirectory, FEATURES_ROOT_DIRECTORY);
        }
        if (requirementsDirectory.exists()) {
            return Optional.of((Object)requirementsDirectory.getAbsolutePath());
        }
        return Optional.absent();
    }

    private boolean absolutePath(String rootDirectoryPath) {
        return new File(rootDirectoryPath).isAbsolute() || rootDirectoryPath.startsWith("/");
    }

    private Enumeration<URL> getDirectoriesFrom(String root) throws IOException, URISyntaxException {
        String rootWithEscapedSpaces = root.replaceAll(" ", "%20");
        URI rootUri = this.isWindowsPath(rootWithEscapedSpaces) ? new File(root).toPath().toUri() : new URI(rootWithEscapedSpaces);
        return this.getClass().getClassLoader().getResources(rootUri.getPath());
    }

    private boolean isWindowsPath(String rootWithEscapedSpaces) {
        return this.WINDOWS_PATH.matcher(rootWithEscapedSpaces).find();
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath())));
            this.addStoryTagIfPresent(tags, storyPathElements);
            storyPathElements = this.stripStorySuffixFrom(storyPathElements);
            tags.addAll(this.getMatchingCapabilities(this.getRequirements(), storyPathElements));
        }
        return tags;
    }

    private List<String> stripStorySuffixFrom(List<String> pathElements) {
        if (!pathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(pathElements))) {
            return this.dropLastElement(pathElements);
        }
        return pathElements;
    }

    private List<String> dropLastElement(List<String> pathElements) {
        ArrayList strippedPathElements = Lists.newArrayList(pathElements);
        strippedPathElements.remove(pathElements.size() - 1);
        return strippedPathElements;
    }

    private void addStoryTagIfPresent(Set<TestTag> tags, List<String> storyPathElements) {
        Optional<TestTag> storyTag = this.storyTagFrom(storyPathElements);
        tags.addAll(storyTag.asSet());
    }

    private Optional<TestTag> storyTagFrom(List<String> storyPathElements) {
        if (!storyPathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(storyPathElements))) {
            String storyName = (String)Lists.reverse(storyPathElements).get(1);
            String storyParent = this.parentElement(storyPathElements);
            String qualifiedName = storyParent == null ? NameConverter.humanize(storyName) : NameConverter.humanize(storyParent).trim() + "/" + NameConverter.humanize(storyName);
            TestTag storyTag = TestTag.withName(qualifiedName).andType(STORY_EXTENSION);
            return Optional.of((Object)storyTag);
        }
        return Optional.absent();
    }

    private String parentElement(List<String> storyPathElements) {
        return storyPathElements.size() > 2 ? (String)Lists.reverse(storyPathElements).get(2) : null;
    }

    private String last(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getFeatureTag().isPresent()) {
            return this.requirementWithMatchingFeatureTag((TestTag)testOutcome.getFeatureTag().get());
        }
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
            return this.lastRequirementFrom(storyPathElements);
        }
        return this.mostSpecificTagRequirementFor(testOutcome);
    }

    private Optional<Requirement> requirementWithMatchingFeatureTag(TestTag featureTag) {
        for (Requirement requirement : this.getFlattenedRequirements()) {
            if (!requirement.asUnqualifiedTag().equals(featureTag)) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private Optional<Requirement> mostSpecificTagRequirementFor(TestOutcome testOutcome) {
        Optional<Requirement> mostSpecificRequirement = Optional.absent();
        int currentSpecificity = -1;
        for (TestTag tag : testOutcome.getTags()) {
            int specificity;
            Optional<Requirement> matchingRequirement = this.getRequirementFor(tag);
            if (!matchingRequirement.isPresent() || currentSpecificity >= (specificity = this.requirementsConfiguration.getRequirementTypes().indexOf(((Requirement)matchingRequirement.get()).getType()))) continue;
            currentSpecificity = specificity;
            mostSpecificRequirement = matchingRequirement;
        }
        return mostSpecificRequirement;
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        for (Requirement requirement : this.getFlattenedRequirements()) {
            if (!requirement.getName().equalsIgnoreCase(testTag.getName()) || !requirement.getType().equalsIgnoreCase(testTag.getType())) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private List<Requirement> getFlattenedRequirements() {
        ArrayList allRequirements = Lists.newArrayList();
        for (Requirement requirement : this.getRequirements()) {
            allRequirements.add(requirement);
            allRequirements.addAll(this.childRequirementsOf(requirement));
        }
        return allRequirements;
    }

    private Collection<Requirement> childRequirementsOf(Requirement requirement) {
        ArrayList childRequirements = Lists.newArrayList();
        for (Requirement childRequirement : requirement.getChildren()) {
            childRequirements.add(childRequirement);
            childRequirements.addAll(this.childRequirementsOf(childRequirement));
        }
        return childRequirements;
    }

    private Optional<Requirement> lastRequirementFrom(List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.absent();
        }
        return this.lastRequirementMatchingPath(this.getRequirements(), storyPathElements);
    }

    private Optional<Requirement> lastRequirementMatchingPath(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.absent();
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (!matchingRequirement.isPresent()) {
            return Optional.absent();
        }
        if (this.tail(storyPathElements).isEmpty()) {
            return matchingRequirement;
        }
        List<Requirement> childRequrements = ((Requirement)matchingRequirement.get()).getChildren();
        return this.lastRequirementMatchingPath(childRequrements, this.tail(storyPathElements));
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return NO_TEST_TAGS;
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (matchingRequirement.isPresent()) {
            TestTag thisTag = ((Requirement)matchingRequirement.get()).asTag();
            List<TestTag> remainingTags = this.getMatchingCapabilities(((Requirement)matchingRequirement.get()).getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return NO_TEST_TAGS;
    }

    private List<String> stripRootFrom(List<String> storyPathElements) {
        return RequirementsPath.stripRootFromPath(this.rootDirectoryPath, storyPathElements);
    }

    private String stripRootPathFrom(String testOutcomePath) {
        String rootPath = ThucydidesSystemProperty.THUCYDIDES_TEST_ROOT.from(this.environmentVariables);
        if (rootPath != null && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private Optional<Requirement> findMatchingRequirementIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(Inflector.getInstance().underscore(storyPathElement, new char[0]), new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement) && !storyPathElement.equalsIgnoreCase(FilenameUtils.removeExtension((String)requirement.getFeatureFileName()))) continue;
            return Optional.of((Object)requirement);
        }
        return Optional.absent();
    }

    private List<Requirement> loadCapabilitiesFrom(File[] requirementDirectories) {
        return Lambda.convert((Object)requirementDirectories, this.toRequirements());
    }

    private List<Requirement> loadStoriesFrom(File[] storyFiles) {
        return Lambda.convert((Object)storyFiles, this.toStoryRequirements());
    }

    private Converter<File, Requirement> toRequirements() {
        return new Converter<File, Requirement>(){

            public Requirement convert(File requirementFileOrDirectory) {
                return FileSystemRequirementsTagProvider.this.readRequirementFrom(requirementFileOrDirectory);
            }
        };
    }

    private Converter<File, Requirement> toStoryRequirements() {
        return new Converter<File, Requirement>(){

            public Requirement convert(File storyFile) {
                return FileSystemRequirementsTagProvider.this.readRequirementsFromStoryOrFeatureFile(storyFile);
            }
        };
    }

    public Requirement readRequirementFrom(File requirementDirectory) {
        Optional<Narrative> requirementNarrative = this.narrativeReader.loadFrom(requirementDirectory, this.level);
        if (requirementNarrative.isPresent()) {
            return this.requirementWithNarrative(requirementDirectory, this.humanReadableVersionOf(requirementDirectory.getName()), (Narrative)requirementNarrative.get());
        }
        return this.requirementFromDirectoryName(requirementDirectory);
    }

    public Requirement readRequirementsFromStoryOrFeatureFile(File storyFile) {
        FeatureType type = this.featureTypeOf(storyFile);
        String defaultStoryName = storyFile.getName().replace(type.getExtension(), "");
        Optional<Narrative> optionalNarrative = type == FeatureType.STORY ? this.loadFromStoryFile(storyFile) : this.loadFromFeatureFile(storyFile);
        String storyName = optionalNarrative.isPresent() ? (String)((Narrative)optionalNarrative.get()).getTitle().or((Object)defaultStoryName) : defaultStoryName;
        Requirement requirement = optionalNarrative.isPresent() ? this.leafRequirementWithNarrative(this.humanReadableVersionOf(storyName), (Narrative)optionalNarrative.get()).withType(type.toString()) : this.storyNamed(storyName).withType(type.toString());
        return requirement.definedInFile(storyFile);
    }

    private Optional<Narrative> loadFromStoryFile(File storyFile) {
        return this.narrativeReader.loadFromStoryFile(storyFile);
    }

    private Optional<Narrative> loadFromFeatureFile(File storyFile) {
        String explicitLocale = this.readLocaleFromFeatureFile(storyFile);
        CucumberParser parser = explicitLocale != null ? new CucumberParser(explicitLocale) : new CucumberParser(this.environmentVariables);
        return parser.loadFeatureNarrative(storyFile);
    }

    private String readLocaleFromFeatureFile(File storyFile) {
        try {
            List featureFileLines = FileUtils.readLines((File)storyFile);
            for (String line : featureFileLines) {
                if (!line.startsWith("#") || !line.contains("language:")) continue;
                return line.substring(line.indexOf("language:") + 10).trim();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private FeatureType featureTypeOf(File storyFile) {
        return storyFile.getName().endsWith(".story") ? FeatureType.STORY : FeatureType.FEATURE;
    }

    private Requirement requirementFromDirectoryName(File requirementDirectory) {
        String shortName = this.humanReadableVersionOf(requirementDirectory.getName());
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withType(this.getDefaultType(this.level)).withNarrative(shortName).withChildren(children);
    }

    private Requirement storyNamed(String storyName) {
        String shortName = this.humanReadableVersionOf(storyName);
        return Requirement.named(shortName).withType(STORY_EXTENSION).withNarrative(shortName);
    }

    private Requirement leafRequirementWithNarrative(String shortName, Narrative requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = (String)requirementNarrative.getCardNumber().orNull();
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        return Requirement.named(shortName).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions);
    }

    private Requirement requirementWithNarrative(File requirementDirectory, String shortName, Narrative requirementNarrative) {
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, shortName);
        String cardNumber = (String)requirementNarrative.getCardNumber().orNull();
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        return Requirement.named(shortName).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions).withChildren(children);
    }

    private List<Requirement> readChildrenFrom(File requirementDirectory) {
        String childDirectory = this.rootDirectoryPath + "/" + requirementDirectory.getName();
        if (this.childrenExistFor(childDirectory)) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(childDirectory, this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        if (this.childrenExistFor(requirementDirectory.getPath())) {
            FileSystemRequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(requirementDirectory.getPath(), this.level + 1, this.environmentVariables);
            return childReader.getRequirements();
        }
        return NO_REQUIREMENTS;
    }

    private boolean childrenExistFor(String path) {
        if (this.hasSubdirectories(path)) {
            return true;
        }
        if (this.hasFeatureOrStoryFiles(path)) {
            return true;
        }
        return this.classpathResourceExistsFor(path);
    }

    private boolean hasFeatureOrStoryFiles(String path) {
        File requirementDirectory = new File(path);
        if (requirementDirectory.isDirectory()) {
            return requirementDirectory.list(this.storyFiles()).length > 0 || requirementDirectory.list(this.featureFiles()).length > 0;
        }
        return false;
    }

    private FilenameFilter storyFiles() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".story");
            }
        };
    }

    private FilenameFilter featureFiles() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".feature");
            }
        };
    }

    private boolean classpathResourceExistsFor(String path) {
        return this.getClass().getResource(this.resourcePathFor(path)) != null;
    }

    private String resourcePathFor(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private boolean hasSubdirectories(String path) {
        File pathDirectory = new File(path);
        if (!pathDirectory.exists()) {
            return false;
        }
        for (File subdirectory : pathDirectory.listFiles()) {
            if (!subdirectory.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private String getTitleFromNarrativeOrDirectoryName(Narrative requirementNarrative, String nameIfNoNarrativePresent) {
        if (requirementNarrative.getTitle().isPresent()) {
            return (String)requirementNarrative.getTitle().get();
        }
        return nameIfNoNarrativePresent;
    }

    private FileFilter thatAreDirectories() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() && !file.getName().startsWith(".");
            }
        };
    }

    private FileFilter thatAreStories() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                String filename = file.getName().toLowerCase();
                if (filename.startsWith("given") || filename.startsWith("precondition")) {
                    return false;
                }
                return file.getName().toLowerCase().endsWith(".story") || file.getName().toLowerCase().endsWith(".feature");
            }
        };
    }

    public static Optional<String> getResourceDirectory(EnvironmentVariables environmentVariables) {
        if (ThucydidesSystemProperty.THUCYDIDES_REQUIREMENTS_DIR.isDefinedIn(environmentVariables)) {
            return Optional.absent();
        }
        return Optional.of((Object)DEFAULT_RESOURCE_DIRECTORY);
    }

    private boolean isSupportedFileStoryExtension(String storyFileExtension) {
        return storyFileExtension.toLowerCase().equals(FEATURE_EXTENSION) || storyFileExtension.toLowerCase().equals(STORY_EXTENSION);
    }
}

