/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reflection;

import java.lang.reflect.Method;

public class StackTraceAnalyser {
    private final StackTraceElement stackTraceElement;

    private StackTraceAnalyser(StackTraceElement stackTraceElement) {
        this.stackTraceElement = stackTraceElement;
    }

    public static StackTraceAnalyser forStackTraceElement(StackTraceElement stackTraceElement) {
        return new StackTraceAnalyser(stackTraceElement);
    }

    public Method getMethod() {
        try {
            Class<?> callingClass;
            Method matchingMethod;
            if (this.allowedClassName(this.stackTraceElement.getClassName()) && (matchingMethod = StackTraceAnalyser.extractMethod(this.stackTraceElement, callingClass = Class.forName(this.stackTraceElement.getClassName()))) != null) {
                return matchingMethod;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public static Method extractMethod(StackTraceElement stackTraceElement, Class callingClass) {
        Class targetClass = StackTraceAnalyser.isInstrumentedMethod(stackTraceElement) ? callingClass.getSuperclass() : callingClass;
        try {
            return targetClass.getMethod(stackTraceElement.getMethodName(), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static boolean isInstrumentedMethod(StackTraceElement stackTraceElement) {
        return stackTraceElement.getFileName() != null && stackTraceElement.getFileName().equals("<generated>");
    }

    private boolean allowedClassName(String className) {
        return !className.startsWith("sun.") && !className.startsWith("java.");
    }
}

