/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model.stacktrace;

import com.google.common.base.Optional;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import net.serenitybdd.core.exceptions.SerenityWebDriverException;
import net.serenitybdd.core.exceptions.UnrecognisedException;
import net.thucydides.core.model.TestFailureException;

public class FailureCause {
    public static final String ERROR_MESSAGE_LABEL_1 = "{'errorMessage':";
    public static final String ERROR_MESSAGE_LABEL_2 = "{\"errorMessage\":";
    private String errorType;
    private String message;
    private StackTraceElement[] stackTrace;

    public FailureCause() {
    }

    public FailureCause(Throwable cause) {
        this.errorType = FailureCause.exceptionClassName(cause);
        this.message = cause.getMessage();
        this.stackTrace = cause.getStackTrace();
    }

    public FailureCause(Throwable cause, StackTraceElement[] stackTrace) {
        this(FailureCause.exceptionClassName(cause), cause.getMessage(), stackTrace);
    }

    private static String exceptionClassName(Throwable cause) {
        if (cause instanceof SerenityWebDriverException) {
            return ((SerenityWebDriverException)((Object)cause)).getExceptionClass().getName();
        }
        return cause.getClass().getName();
    }

    public FailureCause(String errorType, String message, StackTraceElement[] stackTrace) {
        this.errorType = errorType;
        this.message = this.parseErrorMessage(message);
        this.stackTrace = stackTrace;
    }

    private String parseErrorMessage(String message) {
        if (message != null && (message.startsWith(ERROR_MESSAGE_LABEL_1) || message.startsWith(ERROR_MESSAGE_LABEL_2))) {
            return this.extractErrorMessageTextFrom(message);
        }
        return message;
    }

    private String extractErrorMessageTextFrom(String message) {
        int endOfMessage = (message = message.substring(ERROR_MESSAGE_LABEL_1.length() + 1)).indexOf("','");
        if (endOfMessage == -1) {
            endOfMessage = message.indexOf("\",\"");
        }
        if (endOfMessage > 0) {
            return message.substring(0, endOfMessage);
        }
        return message;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public String getMessage() {
        return this.message;
    }

    public StackTraceElement[] getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(StackTraceElement[] stackTrace) {
        this.stackTrace = stackTrace;
    }

    public Class<? extends Throwable> exceptionClass() {
        try {
            return Class.forName(this.errorType);
        }
        catch (ClassNotFoundException e) {
            return Throwable.class;
        }
    }

    public String toString() {
        return "FailureCause{errorType='" + this.errorType + '\'' + ", message='" + this.message + '\'' + ", stackTrace=" + Arrays.toString(this.stackTrace) + '}';
    }

    public Throwable toException() {
        Optional<? extends Throwable> exception = this.restoreExceptionFrom(this.errorType, this.message);
        if (exception.isPresent()) {
            return (Throwable)exception.get();
        }
        return new TestFailureException(this.errorType + ":" + this.message);
    }

    private Optional<? extends Throwable> restoreExceptionFrom(String testFailureClassname, String testFailureMessage) {
        try {
            Class<?> failureClass = Class.forName(testFailureClassname);
            Object exception = this.buildThrowable(testFailureMessage, failureClass);
            if (exception == null) {
                exception = new UnrecognisedException(failureClass.getName() + ": " + testFailureMessage);
            }
            ((Throwable)exception).setStackTrace(this.getStackTrace());
            return Optional.fromNullable(exception);
        }
        catch (Exception e) {
            UnrecognisedException exception = new UnrecognisedException(testFailureClassname + ": " + testFailureMessage);
            exception.setStackTrace(this.getStackTrace());
            return Optional.fromNullable((Object)exception);
        }
    }

    private <T extends Throwable> T buildThrowable(String testFailureMessage, Class failureClass) throws Exception {
        if (this.defaultConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)((Constructor)this.defaultConstructorFor(failureClass).get()).newInstance(new Object[0]));
        }
        if (this.stringConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)((Constructor)this.stringConstructorFor(failureClass).get()).newInstance(testFailureMessage));
        }
        if (this.stringThrowableConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)((Constructor)this.stringThrowableConstructorFor(failureClass).get()).newInstance(testFailureMessage, null));
        }
        if (this.throwableConstructorFor(failureClass).isPresent()) {
            return (T)((Throwable)((Constructor)this.throwableConstructorFor(failureClass).get()).newInstance(new AssertionError((Object)testFailureMessage)));
        }
        return null;
    }

    private Optional<Constructor> defaultConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.fromNullable(failureClass.getConstructor(new Class[0]));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    private Optional<Constructor> stringConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.fromNullable(failureClass.getConstructor(String.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    private Optional<Constructor> stringThrowableConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.fromNullable(failureClass.getConstructor(String.class, Throwable.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }

    private Optional<Constructor> throwableConstructorFor(Class failureClass) throws NoSuchMethodException {
        try {
            return Optional.fromNullable(failureClass.getConstructor(Throwable.class));
        }
        catch (NoSuchMethodException e) {
            return Optional.absent();
        }
    }
}

