/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.thucydides.core.annotations.TestAnnotations;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.html.Formatter;

class TestOutcomeAnnotationReader {
    private final TestOutcome testOutcome;

    public static TestOutcomeAnnotationReader forTestOutcome(TestOutcome testOutcome) {
        return new TestOutcomeAnnotationReader(testOutcome);
    }

    TestOutcomeAnnotationReader(TestOutcome testOutcome) {
        this.testOutcome = testOutcome;
    }

    public List<String> readIssues() {
        ArrayList taggedIssues = Lists.newArrayList();
        if (this.testOutcome.getTestCase() != null) {
            this.addMethodLevelIssuesTo(taggedIssues);
            this.addClassLevelIssuesTo(taggedIssues);
        }
        this.addTitleLevelIssuesTo(taggedIssues);
        return taggedIssues;
    }

    public List<String> readVersions() {
        ArrayList taggedVersions = Lists.newArrayList();
        if (this.testOutcome.getTestCase() != null) {
            this.addMethodLevelVersionsTo(taggedVersions);
            this.addClassLevelVersionsTo(taggedVersions);
        }
        return taggedVersions;
    }

    private void addClassLevelIssuesTo(List<String> issues) {
        String[] classIssues;
        String classIssue = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedIssueForTestCase(this.testOutcome.getTestCase());
        if (classIssue != null) {
            issues.add(classIssue);
        }
        if ((classIssues = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedIssuesForTestCase(this.testOutcome.getTestCase())) != null) {
            issues.addAll(Arrays.asList(classIssues));
        }
    }

    private void addMethodLevelIssuesTo(List<String> issues) {
        Optional<String> issue = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedIssueForMethod(this.testOutcome.getName());
        if (issue.isPresent()) {
            issues.add((String)issue.get());
        }
        String[] multipleIssues = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedIssuesForMethod(this.testOutcome.getName());
        issues.addAll(Arrays.asList(multipleIssues));
    }

    private void addTitleLevelIssuesTo(List<String> issues) {
        List<String> titleIssues = Formatter.issuesIn(this.testOutcome.getTitle());
        if (!titleIssues.isEmpty()) {
            issues.addAll(titleIssues);
        }
    }

    private void addClassLevelVersionsTo(List<String> versions) {
        String classVersion = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedVersionForTestCase(this.testOutcome.getTestCase());
        if (classVersion != null) {
            versions.add(classVersion);
        }
    }

    private void addMethodLevelVersionsTo(List<String> versions) {
        Optional<String> version = TestAnnotations.forClass(this.testOutcome.getTestCase()).getAnnotatedVersionForMethod(this.testOutcome.getName());
        if (version.isPresent()) {
            versions.add((String)version.get());
        }
    }
}

