/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.bootstrap;

import com.google.common.base.Optional;
import java.io.File;
import java.util.List;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.pages.Pages;
import net.thucydides.core.reports.ReportService;
import net.thucydides.core.steps.BaseStepListener;
import net.thucydides.core.steps.Listeners;
import net.thucydides.core.steps.StepAnnotations;
import net.thucydides.core.steps.StepEventBus;
import net.thucydides.core.steps.StepFactory;
import net.thucydides.core.steps.StepListener;
import net.thucydides.core.webdriver.Configuration;
import net.thucydides.core.webdriver.WebDriverFactory;
import net.thucydides.core.webdriver.WebdriverManager;
import org.openqa.selenium.WebDriver;

class ThucydidesContext {
    private static final ThreadLocal<ThucydidesContext> contextThreadLocal = new ThreadLocal();
    private final StepFactory stepFactory;
    private BaseStepListener stepListener;
    private final ReportService reportService;
    private File outputDirectory;
    private String defaultDriver;
    private WebDriverFactory webDriverFactory;
    private Pages pages;
    private Configuration configuration = (Configuration)Injectors.getInjector().getInstance(Configuration.class);
    private WebdriverManager webdriverManager = (WebdriverManager)Injectors.getInjector().getInstance(WebdriverManager.class);

    private ThucydidesContext(StepListener ... additionalListeners) {
        this((String)null, additionalListeners);
    }

    private ThucydidesContext(String defaultDriver, StepListener ... additionalListeners) {
        this.outputDirectory = this.configuration.getOutputDirectory();
        this.defaultDriver = defaultDriver;
        if (defaultDriver != null) {
            this.webDriverFactory = new WebDriverFactory();
            this.pages = new Pages(this.getDriver());
            this.stepFactory = new StepFactory(this.pages);
        } else {
            this.stepFactory = new StepFactory();
        }
        this.registerStepListeners(additionalListeners);
        this.reportService = new ReportService(this.outputDirectory, ReportService.getDefaultReporters());
    }

    protected WebDriver getDriver() {
        return this.webdriverManager.getWebdriver(this.defaultDriver);
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    private void registerStepListeners(StepListener ... additionalListeners) {
        this.stepListener = this.buildBaseStepListener();
        StepEventBus.getEventBus().registerListener(this.stepListener);
        for (StepListener listener : additionalListeners) {
            StepEventBus.getEventBus().registerListener(listener);
        }
    }

    public static ThucydidesContext newContext() {
        return new ThucydidesContext(new StepListener[0]);
    }

    public static ThucydidesContext newContext(Optional<String> driver, StepListener ... listeners) {
        ThucydidesContext context = null;
        context = driver.isPresent() ? new ThucydidesContext((String)driver.get(), listeners) : new ThucydidesContext(listeners);
        contextThreadLocal.set(context);
        return context;
    }

    public static ThucydidesContext getCurrentContext() {
        return contextThreadLocal.get();
    }

    public void initialize(Object testCase) {
        StepAnnotations.injectScenarioStepsInto(testCase, this.stepFactory);
    }

    public void generateReports() {
        this.reportService.generateReportsFor(this.latestTestOutcomes());
    }

    private List<TestOutcome> latestTestOutcomes() {
        return this.stepListener.getTestOutcomes();
    }

    public void dropListeners() {
        StepEventBus.getEventBus().dropAllListeners();
    }

    private BaseStepListener buildBaseStepListener() {
        return Listeners.getBaseStepListener().withOutputDirectory(this.outputDirectory);
    }
}

