/*
 * Decompiled with CFR 0.152.
 */
package net.revelc.code.formatter.javascript;

import java.io.IOException;
import java.util.Map;
import net.revelc.code.formatter.AbstractCacheableFormatter;
import net.revelc.code.formatter.ConfigurationSource;
import net.revelc.code.formatter.Formatter;
import net.revelc.code.formatter.LineEnding;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;

public class JavascriptFormatter
extends AbstractCacheableFormatter
implements Formatter {
    private CodeFormatter formatter;

    @Override
    public void init(Map<String, String> options, ConfigurationSource cfg) {
        super.initCfg(cfg);
        this.formatter = ToolFactory.createCodeFormatter(options, (int)1);
    }

    @Override
    public String doFormat(String code, LineEnding ending) throws IOException, BadLocationException {
        TextEdit te = this.formatter.format(8, code, 0, code.length(), 0, ending.getChars());
        if (te == null) {
            this.log.debug((CharSequence)"Code cannot be formatted. Possible cause is unmatched source/target/compliance version.");
            return null;
        }
        Document doc = new Document(code);
        te.apply((IDocument)doc);
        String formattedCode = doc.get();
        if (code.equals(formattedCode)) {
            return null;
        }
        return formattedCode;
    }

    @Override
    public boolean isInitialized() {
        return this.formatter != null;
    }
}

