/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.hash.impl.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.hash.impl.util.Cleaner;

public class CleanerUtils {
    private static final Method CREATE_METHOD;
    private static final Method CLEAN_METHOD;

    public static Cleaner createCleaner(Object ob, Runnable thunk) {
        try {
            Object cleanerInstance = CREATE_METHOD.invoke(null, ob, thunk);
            return () -> CleanerUtils.doClean(cleanerInstance);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Jvm.error().on(CleanerUtils.class, "Unable to create cleaner", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void doClean(Object cleanerInstance) {
        try {
            CLEAN_METHOD.invoke(cleanerInstance, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            Jvm.warn().on(CleanerUtils.class, "Failed to clean buffer", (Throwable)e);
        }
    }

    static {
        try {
            Class<?> cleanerClass = Class.forName(Jvm.isJava9Plus() ? "jdk.internal.ref.Cleaner" : "sun.misc.Cleaner");
            CREATE_METHOD = cleanerClass.getDeclaredMethod("create", Object.class, Runnable.class);
            Jvm.setAccessible((AccessibleObject)CREATE_METHOD);
            CLEAN_METHOD = cleanerClass.getDeclaredMethod("clean", new Class[0]);
            Jvm.setAccessible((AccessibleObject)CLEAN_METHOD);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            Jvm.error().on(CleanerUtils.class, "Unable to initialise CleanerUtils", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

