/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.fs.ConfigurationFS;
import net.openhft.chronicle.engine.map.InsertedEvent;
import net.openhft.chronicle.engine.map.RemovedEvent;
import net.openhft.chronicle.engine.map.UpdatedEvent;
import net.openhft.chronicle.engine.map.remote.KeyFunctionPair;
import net.openhft.chronicle.engine.map.remote.KeyValueFunctionTuple;
import net.openhft.chronicle.engine.map.remote.KeyValuePair;
import net.openhft.chronicle.engine.map.remote.KeyValuesTuple;
import net.openhft.chronicle.engine.map.remote.MapFunction;
import net.openhft.chronicle.engine.map.remote.MapUpdate;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.ExistingAssetEvent;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaAssetTree
implements AssetTree {
    @NotNull
    final VanillaAsset root;

    public VanillaAssetTree() {
        this("");
    }

    public VanillaAssetTree(@Nullable String name) {
        this.root = new VanillaAsset(null, name == null ? "" : name);
    }

    public VanillaAssetTree(int hostId) {
        this();
        this.root.addView(HostIdentifier.class, new HostIdentifier((byte)hostId));
    }

    @Override
    public AssetTreeStats getUsageStats() {
        AssetTreeStats ats = new AssetTreeStats();
        this.root.getUsageStats(ats);
        return ats;
    }

    @NotNull
    public VanillaAssetTree forTesting(Consumer<Throwable> onThrowable) {
        return this.forTesting(true, onThrowable);
    }

    @NotNull
    public VanillaAssetTree forTesting(boolean daemon, Consumer<Throwable> onThrowable) {
        return this.forServer(daemon, onThrowable);
    }

    @NotNull
    public VanillaAssetTree forServer(Consumer<Throwable> onThrowable) {
        return this.forServer(true, onThrowable);
    }

    @NotNull
    public VanillaAssetTree forServer(boolean daemon, Consumer<Throwable> onThrowable) {
        this.root.forServer(daemon, onThrowable);
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String hostPortDescription, @NotNull Function<Bytes, Wire> wire, Consumer<Throwable> onThrowable) {
        return this.forRemoteAccess(new String[]{hostPortDescription}, wire, onThrowable);
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(@NotNull String[] hostPortDescription, @NotNull Function<Bytes, Wire> wire, Consumer<Throwable> onThrowable) {
        this.root.forRemoteAccess(hostPortDescription, wire, this.clientSession(), null, onThrowable);
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(@NotNull String[] hostPortDescription, @NotNull Function<Bytes, Wire> wire, @Nullable ClientConnectionMonitor clientConnectionMonitor, Consumer<Throwable> onThrowable) {
        if (clientConnectionMonitor != null) {
            this.root.viewMap.put(ClientConnectionMonitor.class, clientConnectionMonitor);
        }
        this.root.forRemoteAccess(hostPortDescription, wire, this.clientSession(), clientConnectionMonitor, onThrowable);
        return this;
    }

    @NotNull
    public VanillaAssetTree forRemoteAccess(String hostPortDescription, Consumer<Throwable> onThrowable) {
        return this.forRemoteAccess(hostPortDescription, (Function<Bytes, Wire>)WireType.BINARY, onThrowable);
    }

    @NotNull
    private VanillaSessionDetails clientSession() {
        VanillaSessionDetails sessionDetails = new VanillaSessionDetails();
        sessionDetails.setUserId(System.getProperty("user.name"));
        return sessionDetails;
    }

    @Override
    @NotNull
    public Asset acquireAsset(@NotNull String fullName) {
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.acquireAsset(fullName);
    }

    @Override
    @Nullable
    public Asset getAsset(@NotNull String fullName) {
        if (fullName.startsWith("/")) {
            fullName = fullName.substring(1);
        }
        return fullName.isEmpty() ? this.root : this.root.getAsset(fullName);
    }

    @Override
    @NotNull
    public VanillaAsset root() {
        return this.root;
    }

    public void close() {
        this.root.notifyClosing();
        Jvm.pause((long)100L);
        try {
            EventLoop view = this.root().findView(EventLoop.class);
            Closeable.closeQuietly((Object)view);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.root.close();
    }

    @Deprecated
    @NotNull
    public AssetTree withConfig(String etcDir, String baseDir) {
        Threads.withThreadGroup((ThreadGroup)this.root.getView(ThreadGroup.class), () -> {
            new ConfigurationFS("/etc", etcDir, baseDir).install(baseDir, this);
            return null;
        });
        return this;
    }

    @NotNull
    public String toString() {
        return "tree-" + Optional.ofNullable(this.root.getView(HostIdentifier.class)).map(HostIdentifier::hostId).orElseGet(() -> (byte)0);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{AddedAssetEvent.class, ExistingAssetEvent.class, RemovedAssetEvent.class, InsertedEvent.class, UpdatedEvent.class, MapFunction.class, MapUpdate.class, RemovedEvent.class, KeyFunctionPair.class, KeyValueFunctionTuple.class, KeyValuesTuple.class, KeyValuePair.class});
    }
}

