/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.annotation.ForceInline;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.util.ThrowingAcceptor;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.AssetTreeStats;
import net.openhft.chronicle.engine.api.tree.KeyedView;
import net.openhft.chronicle.engine.api.tree.LeafViewFactory;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.WrappingViewFactory;
import net.openhft.chronicle.engine.collection.VanillaValuesCollection;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.MapKVSSubscription;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.map.QueueObjectSubscription;
import net.openhft.chronicle.engine.map.RawKVSSubscription;
import net.openhft.chronicle.engine.map.RemoteEntrySetView;
import net.openhft.chronicle.engine.map.VanillaEntrySetView;
import net.openhft.chronicle.engine.map.VanillaKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.map.VanillaStringMarshallableKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaStringStringKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaSubscriptionKeyValueStore;
import net.openhft.chronicle.engine.map.remote.RemoteKVSSubscription;
import net.openhft.chronicle.engine.map.remote.RemoteKeyValueStore;
import net.openhft.chronicle.engine.map.remote.RemoteMapView;
import net.openhft.chronicle.engine.map.remote.RemoteTopologySubscription;
import net.openhft.chronicle.engine.pubsub.MapReference;
import net.openhft.chronicle.engine.pubsub.MapTopicPublisher;
import net.openhft.chronicle.engine.pubsub.QueueReference;
import net.openhft.chronicle.engine.pubsub.QueueTopicPublisher;
import net.openhft.chronicle.engine.pubsub.RemoteTopicPublisher;
import net.openhft.chronicle.engine.session.VanillaSessionProvider;
import net.openhft.chronicle.engine.set.RemoteKeySetView;
import net.openhft.chronicle.engine.set.VanillaKeySetView;
import net.openhft.chronicle.engine.tree.AddedAssetEvent;
import net.openhft.chronicle.engine.tree.ChronicleQueueView;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.engine.tree.RemovedAssetEvent;
import net.openhft.chronicle.engine.tree.SubAssetFactory;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.engine.tree.VanillaReplication;
import net.openhft.chronicle.engine.tree.VanillaSubAssetFactory;
import net.openhft.chronicle.engine.tree.VanillaTopologySubscription;
import net.openhft.chronicle.network.ClientSessionProvider;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaAsset
implements Asset,
Closeable {
    public static final Comparator<Class> CLASS_COMPARATOR = Comparator.comparing(Class::getName);
    private static final Logger LOG = LoggerFactory.getLogger(VanillaAsset.class);
    private static final String LAST = "{last}";
    private static final BiPredicate<RequestContext, Asset> ALWAYS = (rc, asset) -> true;
    final Map<Class, Object> viewMap = new ConcurrentSkipListMap<Class, Object>(CLASS_COMPARATOR);
    final ConcurrentMap<String, Asset> children = new ConcurrentSkipListMap<String, Asset>();
    private final Asset parent;
    @NotNull
    private final String name;
    private final Map<Class, SortedMap<String, WrappingViewRecord>> wrappingViewFactoryMap = new ConcurrentSkipListMap<Class, SortedMap<String, WrappingViewRecord>>(CLASS_COMPARATOR);
    private final Map<Class, LeafViewFactory> leafViewFactoryMap = new ConcurrentSkipListMap<Class, LeafViewFactory>(CLASS_COMPARATOR);
    private String fullName = null;
    private Boolean keyedAsset;

    public VanillaAsset(Asset asset, @NotNull String name) {
        TopologySubscription parentSubs;
        this.parent = asset;
        this.name = name;
        if ("".equals(name) ? !$assertionsDisabled && this.parent != null : !$assertionsDisabled && name == null) {
            throw new AssertionError();
        }
        if (this.parent != null && (parentSubs = this.parent.findView(TopologySubscription.class)) != null && !(parentSubs instanceof RemoteTopologySubscription)) {
            parentSubs.notifyEvent(AddedAssetEvent.of(this.parent.fullName(), name));
        }
    }

    public void standardStack(boolean daemon, Consumer<Throwable> onThrowable) {
        Asset queue = this.acquireAsset("queue");
        queue.addWrappingRule(Publisher.class, "{last}reference to a ChronicleQueue", QueueReference::new, QueueView.class);
        queue.addWrappingRule(TopicPublisher.class, "{last}reference to a ChronicleQueue", QueueTopicPublisher::new, QueueView.class);
        queue.addLeafRule(ObjectSubscription.class, "{last} vanilla queue subscription", QueueObjectSubscription::new);
        this.addLeafRule((Class)QueueView.class, "{last}chronicle queue", (LeafViewFactory)ChronicleQueueView::new);
        this.addWrappingRule((Class)Reference.class, "{last}reference", (WrappingViewFactory)MapReference::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)Replication.class, "{last}replication", (WrappingViewFactory)VanillaReplication::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)Publisher.class, "{last}publisher", (WrappingViewFactory)MapReference::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)ValuesCollection.class, "{last} values", (WrappingViewFactory)VanillaValuesCollection::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)MapView.class, "{last} string key maps", (WrappingViewFactory)VanillaMapView::new, (Class<U>)ObjectKeyValueStore.class);
        this.addView(SubAssetFactory.class, new VanillaSubAssetFactory());
        String fullName = this.fullName();
        HostIdentifier hostIdentifier = this.findView(HostIdentifier.class);
        if (hostIdentifier != null) {
            fullName = "tree-" + hostIdentifier.hostId() + fullName;
        }
        ThreadGroup threadGroup = new ThreadGroup(fullName);
        this.addView(ThreadGroup.class, threadGroup);
        this.addLeafRule((Class)EventLoop.class, "{last} event group", (LeafViewFactory)(rc, asset) -> (EventLoop)Threads.withThreadGroup((ThreadGroup)threadGroup, () -> {
            EventGroup eg = new EventGroup(daemon, onThrowable);
            eg.start();
            return eg;
        }));
        this.addView(SessionProvider.class, new VanillaSessionProvider());
    }

    public void forServer(Consumer<Throwable> onThrowable) {
        this.forServer(true, onThrowable);
    }

    public void forServer(boolean daemon, Consumer<Throwable> onThrowable) {
        this.standardStack(daemon, onThrowable);
        this.addWrappingRule((Class)EntrySetView.class, "{last} entrySet", (WrappingViewFactory)VanillaEntrySetView::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)TopicPublisher.class, "{last} topic publisher", (WrappingViewFactory)MapTopicPublisher::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{last} authenticated", (WrappingViewFactory)VanillaSubscriptionKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addWrappingRule((Class)KeySetView.class, "{last} keySet", (WrappingViewFactory)VanillaKeySetView::new, (Class<U>)MapView.class);
        this.addLeafRule((Class)AuthenticatedKeyValueStore.class, "{last} vanilla", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)SubscriptionKeyValueStore.class, "{last} vanilla", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)KeyValueStore.class, "{last} vanilla", (LeafViewFactory)VanillaKeyValueStore::new);
        this.addLeafRule((Class)ObjectSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
        this.addLeafRule((Class)RawKVSSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
        this.addLeafRule((Class)TopologySubscription.class, "{last} vanilla", (LeafViewFactory)VanillaTopologySubscription::new);
    }

    public void forRemoteAccess(@NotNull String[] hostPortDescriptions, @NotNull Function<Bytes, Wire> wire, @NotNull VanillaSessionDetails sessionDetails, @Nullable ClientConnectionMonitor clientConnectionMonitor, Consumer<Throwable> onThrowable) throws AssetNotFoundException {
        this.standardStack(true, onThrowable);
        this.addWrappingRule((Class)EntrySetView.class, "{last} entrySet", (WrappingViewFactory)RemoteEntrySetView::new, (Class<U>)MapView.class);
        this.addWrappingRule((Class)MapView.class, "{last} remote key maps", (WrappingViewFactory)RemoteMapView::new, (Class<U>)ObjectKeyValueStore.class);
        this.addWrappingRule((Class)KeySetView.class, "{last} remote key maps", (WrappingViewFactory)RemoteKeySetView::new, (Class<U>)MapView.class);
        Asset queue = this.acquireAsset("queue");
        queue.addLeafRule(ObjectSubscription.class, "{last} Remote", RemoteKVSSubscription::new);
        this.addLeafRule((Class)ObjectSubscription.class, "{last} Remote", (LeafViewFactory)RemoteKVSSubscription::new);
        this.addLeafRule((Class)RawKVSSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
        this.addLeafRule((Class)ObjectKeyValueStore.class, "{last} Remote AKVS", (LeafViewFactory)RemoteKeyValueStore::new);
        this.addWrappingRule((Class)TopicPublisher.class, "{last} topic publisher", (WrappingViewFactory)RemoteTopicPublisher::new, (Class<U>)MapView.class);
        this.addLeafRule((Class)TopologySubscription.class, "{last} vanilla", (LeafViewFactory)RemoteTopologySubscription::new);
        ClientSessionProvider sessionProvider = new ClientSessionProvider((SessionDetails)sessionDetails);
        EventLoop eventLoop = this.findOrCreateView(EventLoop.class);
        eventLoop.start();
        if (this.getView(TcpChannelHub.class) == null) {
            SocketAddressSupplier socketAddressSupplier = new SocketAddressSupplier(hostPortDescriptions, this.name);
            TcpChannelHub view = (TcpChannelHub)Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> this.lambda$forRemoteAccess$195((SessionProvider)sessionProvider, eventLoop, wire, socketAddressSupplier, clientConnectionMonitor));
            this.addView(TcpChannelHub.class, view);
        }
    }

    public void enableTranslatingValuesToBytesStore() {
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{Marshalling} string,string map", (RequestContext rc, Asset asset) -> rc.keyType() == String.class && rc.valueType() == String.class, (WrappingViewFactory)VanillaStringStringKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addWrappingRule((Class)ObjectKeyValueStore.class, "{Marshalling} string,marshallable map", (RequestContext rc, Asset asset) -> rc.keyType() == String.class && Marshallable.class.isAssignableFrom(rc.valueType()), (WrappingViewFactory)VanillaStringMarshallableKeyValueStore::new, (Class<U>)AuthenticatedKeyValueStore.class);
        this.addLeafRule((Class)RawKVSSubscription.class, "{last} vanilla", (LeafViewFactory)MapKVSSubscription::new);
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        SortedMap smap = this.wrappingViewFactoryMap.computeIfAbsent(viewType, k -> new ConcurrentSkipListMap());
        smap.put(description, new WrappingViewRecord<W, U>(predicate, factory, underlyingType));
    }

    public <W, U> void addWrappingRule(Class<W> viewType, String description, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
        this.addWrappingRule(viewType, description, ALWAYS, factory, underlyingType);
        this.leafViewFactoryMap.remove(viewType);
    }

    public <L> void addLeafRule(Class<L> viewType, String description, LeafViewFactory<L> factory) {
        this.leafViewFactoryMap.put(viewType, factory);
    }

    @Nullable
    public <I, U> I createWrappingView(Class viewType, RequestContext rc, @NotNull Asset asset, @Nullable U underling) throws AssetNotFoundException {
        SortedMap<String, WrappingViewRecord> smap = this.wrappingViewFactoryMap.get(viewType);
        if (smap != null) {
            for (WrappingViewRecord wvRecord : smap.values()) {
                if (!wvRecord.predicate.test(rc, asset)) continue;
                if (underling == null) {
                    underling = asset.acquireView(wvRecord.underlyingType, rc);
                }
                return (I)wvRecord.factory.create(rc, asset, underling);
            }
        }
        if (this.parent == null) {
            return null;
        }
        return ((VanillaAsset)this.parent).createWrappingView(viewType, rc, asset, underling);
    }

    @Nullable
    public <I> I createLeafView(Class viewType, @NotNull RequestContext rc, Asset asset) throws AssetNotFoundException {
        LeafViewFactory lvFactory = this.leafViewFactoryMap.get(viewType);
        if (lvFactory != null) {
            return lvFactory.create(rc.clone().viewType(viewType), asset);
        }
        if (this.parent == null) {
            return null;
        }
        return ((VanillaAsset)this.parent).createLeafView(viewType, rc, asset);
    }

    @Override
    public boolean isSubAsset() {
        return false;
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public void forEachChild(@NotNull ThrowingAcceptor<Asset, InvalidSubscriberException> childAcceptor) throws InvalidSubscriberException {
        for (Asset child : this.children.values()) {
            childAcceptor.accept((Object)child);
        }
    }

    @Override
    @ForceInline
    @Nullable
    public <V> V getView(@NotNull Class<V> viewType) {
        Object view = this.viewMap.get(viewType);
        return (V)view;
    }

    @Override
    @ForceInline
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public String fullName() {
        if (this.fullName == null) {
            this.fullName = Asset.super.fullName();
        }
        return this.fullName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public <V> V acquireView(@NotNull Class<V> viewType, @NotNull RequestContext rc) throws AssetNotFoundException {
        Map<Class, Object> map = this.viewMap;
        synchronized (map) {
            V view = this.getView(viewType);
            if (view != null) {
                return view;
            }
            return (V)Threads.withThreadGroup((ThreadGroup)this.findView(ThreadGroup.class), () -> {
                Object leafView = this.createLeafView(viewType, rc, this);
                if (leafView != null) {
                    return this.addView(viewType, leafView);
                }
                Object wrappingView = this.createWrappingView(viewType, rc, this, null);
                if (wrappingView == null) {
                    throw new AssetNotFoundException("Unable to classify " + viewType.getName() + " context: " + rc);
                }
                return this.addView(viewType, wrappingView);
            });
        }
    }

    @Override
    public <V> V addView(Class<V> viewType, V view) {
        if (view instanceof KeyedView) {
            this.keyedAsset = ((KeyedView)view).keyedView();
        }
        this.viewMap.put(viewType, view);
        return view;
    }

    public <I> void registerView(Class<I> viewType, I view) {
        this.viewMap.put(viewType, view);
    }

    @Override
    @Nullable
    public SubscriptionCollection subscription(boolean createIfAbsent) throws AssetNotFoundException {
        return createIfAbsent ? (SubscriptionCollection)this.acquireView(ObjectSubscription.class) : (SubscriptionCollection)this.getView(ObjectSubscription.class);
    }

    public void close() {
        this.viewMap.values().stream().filter(v -> v instanceof java.io.Closeable).forEach(Closeable::closeQuietly);
        try {
            this.forEachChild((ThrowingAcceptor<Asset, InvalidSubscriberException>)((ThrowingAcceptor)Closeable::close));
        }
        catch (InvalidSubscriberException e) {
            LOG.error("", (Throwable)e);
        }
    }

    public void notifyClosing() {
        this.viewMap.values().stream().filter(v -> v instanceof Closeable).map(v -> (Closeable)v).forEach(Closeable::notifyClosing);
        try {
            this.forEachChild((ThrowingAcceptor<Asset, InvalidSubscriberException>)((ThrowingAcceptor)Closeable::notifyClosing));
        }
        catch (InvalidSubscriberException e) {
            LOG.error("", (Throwable)e);
        }
    }

    @Override
    @ForceInline
    public Asset parent() {
        return this.parent;
    }

    @Override
    @NotNull
    public Asset acquireAsset(@NotNull String childName) {
        if (this.keyedAsset != Boolean.TRUE) {
            int pos = childName.indexOf(47);
            if (pos == 0) {
                childName = childName.substring(1);
                pos = childName.indexOf(47);
            }
            if (pos > 0) {
                String name1 = childName.substring(0, pos);
                String name2 = childName.substring(pos + 1);
                return this.getAssetOrANFE(name1).acquireAsset(name2);
            }
        }
        return this.getAssetOrANFE(childName);
    }

    @Override
    public <V> boolean hasFactoryFor(Class<V> viewType) {
        return this.leafViewFactoryMap.containsKey(viewType) || this.wrappingViewFactoryMap.containsKey(viewType);
    }

    @Nullable
    private Asset getAssetOrANFE(@NotNull String name) throws AssetNotFoundException {
        Asset asset = (Asset)this.children.get(name);
        if (asset == null && (asset = this.createAsset(name)) == null) {
            throw new AssetNotFoundException(name);
        }
        return asset;
    }

    @Nullable
    protected Asset createAsset(@NotNull String name) {
        assert (name.length() > 0);
        return this.children.computeIfAbsent(name, this.keyedAsset != Boolean.TRUE ? n -> new VanillaAsset(this, name) : n -> {
            MapView map = this.getView(MapView.class);
            if (map != null) {
                if (map.keyType() != String.class) {
                    throw new IllegalStateException("You can only have a SubAsset of a Map with a String key.");
                }
                SubAssetFactory saFactory = this.findOrCreateView(SubAssetFactory.class);
                return saFactory.createSubAsset(this, name, map.valueType());
            }
            QueueView queue = this.getView(QueueView.class);
            if (queue == null) {
                throw new IllegalStateException("You can only have a SubAsset of a Map or Queue");
            }
            SubAssetFactory saFactory = this.findOrCreateView(SubAssetFactory.class);
            return saFactory.createSubAsset(this, name, queue.messageType());
        });
    }

    @Override
    public Asset getChild(String name) {
        return (Asset)this.children.get(name);
    }

    @Override
    public void removeChild(String name) {
        Asset removed = (Asset)this.children.remove(name);
        if (removed == null) {
            return;
        }
        TopologySubscription topologySubscription = removed.findView(TopologySubscription.class);
        if (topologySubscription != null) {
            topologySubscription.notifyEvent(RemovedAssetEvent.of(this.fullName(), name));
        }
    }

    @NotNull
    public String toString() {
        return this.fullName();
    }

    @Override
    public void getUsageStats(AssetTreeStats ats) {
        ats.addAsset(1L, 512L);
        for (Object o : this.viewMap.values()) {
            KeyValueStore kvs;
            if (!(o instanceof KeyValueStore) || (kvs = (KeyValueStore)o).underlying() != null) continue;
            long count = kvs.longSize();
            ats.addAsset(count, count * 1024L);
            break;
        }
        try {
            this.forEachChild((ThrowingAcceptor<Asset, InvalidSubscriberException>)((ThrowingAcceptor)ca -> ca.getUsageStats(ats)));
        }
        catch (InvalidSubscriberException e) {
            throw new AssertionError((Object)e);
        }
    }

    private /* synthetic */ TcpChannelHub lambda$forRemoteAccess$195(SessionProvider sessionProvider, EventLoop eventLoop, Function function, SocketAddressSupplier socketAddressSupplier, ClientConnectionMonitor clientConnectionMonitor) throws Exception {
        return new TcpChannelHub(sessionProvider, eventLoop, function, this.name.isEmpty() ? "/" : this.name, socketAddressSupplier, true, clientConnectionMonitor, HandlerPriority.TIMER);
    }

    static class WrappingViewRecord<W, U> {
        final BiPredicate<RequestContext, Asset> predicate;
        final WrappingViewFactory<W, U> factory;
        final Class<U> underlyingType;

        WrappingViewRecord(BiPredicate<RequestContext, Asset> predicate, WrappingViewFactory<W, U> factory, Class<U> underlyingType) {
            this.predicate = predicate;
            this.factory = factory;
            this.underlyingType = underlyingType;
        }

        @NotNull
        public String toString() {
            return "wraps " + this.underlyingType;
        }
    }
}

