/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.util.Objects;
import java.util.Optional;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;

public class ExistingAssetEvent
implements TopologicalEvent {
    private String assetName;
    private String name;

    private ExistingAssetEvent(String assetName, String name) {
        this.assetName = assetName;
        this.name = name;
    }

    @NotNull
    public static ExistingAssetEvent of(String assetName, String name) {
        return new ExistingAssetEvent(assetName, name);
    }

    @Override
    public boolean added() {
        return true;
    }

    @Override
    public String assetName() {
        return this.assetName;
    }

    @Override
    public String name() {
        return this.name;
    }

    public int hashCode() {
        return Objects.hash("added", this.assetName, this.name);
    }

    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof ExistingAssetEvent).map(o -> (ExistingAssetEvent)o).filter(e -> Objects.equals(this.assetName, e.assetName)).filter(e -> Objects.equals(this.name, e.name)).isPresent();
    }

    @NotNull
    public String toString() {
        return "ExistingAssetEvent{assetName='" + this.assetName + '\'' + ", name='" + this.name + '\'' + '}';
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read((WireKey)TopologicalEvent.TopologicalFields.assetName).text((Object)this, (o, s) -> {
            o.assetName = s;
        });
        wire.read((WireKey)TopologicalEvent.TopologicalFields.name).text((Object)this, (o, s) -> {
            o.name = s;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)TopologicalEvent.TopologicalFields.assetName).text((CharSequence)this.assetName);
        wire.write((WireKey)TopologicalEvent.TopologicalFields.name).object((Object)this.name);
    }
}

