/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.tree;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.tree.QueueView;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.Excerpt;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ChronicleQueueView<T, M>
implements QueueView<T, M> {
    private static final String DEFAULT_BASE_PATH;
    private final ChronicleQueue chronicleQueue;
    private final Class<T> messageTypeClass;
    private final Class<M> elementTypeClass;
    private final ThreadLocal<ThreadLocalData> threadLocal;

    public ChronicleQueueView(RequestContext requestContext, Asset asset) {
        this.chronicleQueue = this.newInstance(requestContext.name(), requestContext.basePath());
        this.messageTypeClass = requestContext.type();
        this.elementTypeClass = requestContext.elementType();
        this.threadLocal = ThreadLocal.withInitial(() -> new ThreadLocalData(this.chronicleQueue));
    }

    @NotNull
    public static String resourcesDir() {
        String path = ChronicleQueueView.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        if (path == null) {
            return ".";
        }
        return new File(path).getParentFile().getParentFile() + "/src/test/resources";
    }

    @Override
    public void publish(@NotNull T topic, @NotNull M message) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void registerTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) throws AssetNotFoundException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void unregisterTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Publisher<M> publisher(@NotNull T topic) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void registerSubscriber(@NotNull T topic, @NotNull Subscriber<M> subscriber) {
        throw new UnsupportedOperationException("todo");
    }

    private ChronicleQueue newInstance(String name, @Nullable String basePath) {
        ChronicleQueue chronicleQueue;
        if (basePath == null) {
            basePath = DEFAULT_BASE_PATH;
        }
        try {
            File baseFilePath = new File(basePath, name);
            baseFilePath.mkdirs();
            chronicleQueue = new SingleChronicleQueueBuilder(baseFilePath).build();
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
        return chronicleQueue;
    }

    @NotNull
    public String name() {
        return this.chronicleQueue.name();
    }

    @NotNull
    public Excerpt createExcerpt() {
        return this.chronicleQueue.createExcerpt();
    }

    @Override
    public ExcerptTailer threadLocalTailer() {
        return this.threadLocal.get().tailer;
    }

    private ExcerptTailer threadLocalReplayTailer() {
        return this.threadLocal.get().replayTailer;
    }

    @Override
    public ExcerptAppender threadLocalAppender() {
        return this.threadLocal.get().appender;
    }

    @Override
    public void threadLocalElement(M e) {
        this.threadLocal.get().element = e;
    }

    @Override
    public M threadLocalElement() {
        return this.threadLocal.get().element;
    }

    @Override
    @NotNull
    public M get(int index) {
        try {
            ExcerptTailer tailer = this.threadLocalTailer();
            if (!tailer.moveToIndex((long)index)) {
                return null;
            }
            return tailer.readDocument(wire -> this.threadLocalElement(wire.read().object(this.elementTypeClass))) ? (M)this.threadLocalElement() : null;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public M get(String name) {
        try {
            ExcerptTailer tailer = this.threadLocalTailer();
            return tailer.readDocument(wire -> {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = wire.readEventName(eventName);
                if (name == null || name.isEmpty() || name.contentEquals(eventName)) {
                    this.threadLocalElement(valueIn.object(this.elementTypeClass));
                }
            }) ? (M)this.threadLocalElement() : null;
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public void get(BiConsumer<CharSequence, M> consumer) {
        try {
            ExcerptTailer tailer = this.threadLocalTailer();
            tailer.readDocument(w -> {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = w.readEventName(eventName);
                consumer.accept(eventName, valueIn.object(this.elementTypeClass));
            });
        }
        catch (Exception e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public long set(@NotNull T name, @NotNull M message) {
        WireKey wireKey = name instanceof WireKey ? (WireKey)name : name::toString;
        return this.threadLocalAppender().writeDocument(w -> w.writeEventName(wireKey).object(message));
    }

    @Override
    public long set(@NotNull M event) {
        return this.threadLocalAppender().writeDocument(w -> w.writeEventName(() -> "").object(event));
    }

    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return this.chronicleQueue.createTailer();
    }

    @NotNull
    public ExcerptAppender createAppender() {
        return this.chronicleQueue.createAppender();
    }

    @Override
    public long size() {
        return this.chronicleQueue.size();
    }

    @Override
    public void clear() {
        this.chronicleQueue.clear();
    }

    public long firstIndex() {
        return this.chronicleQueue.firstIndex();
    }

    public long lastIndex() {
        return this.chronicleQueue.lastIndex();
    }

    @NotNull
    public WireType wireType() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void close() throws IOException {
        this.chronicleQueue.close();
    }

    @Override
    public void replay(long index, @NotNull BiConsumer<T, M> consumer, @Nullable Consumer<Exception> isAbsent) {
        ExcerptTailer excerptTailer = this.threadLocalReplayTailer();
        try {
            excerptTailer.moveToIndex(index);
            excerptTailer.readDocument(w -> w.read());
        }
        catch (Exception e) {
            isAbsent.accept(e);
        }
    }

    @Override
    public Class<T> messageType() {
        return this.messageTypeClass;
    }

    @Override
    public Class<M> elementTypeClass() {
        return this.elementTypeClass;
    }

    static {
        String dir = "/tmp";
        try {
            Path tempDirectory = Files.createTempDirectory("engine-queue", new FileAttribute[0]);
            dir = tempDirectory.toAbsolutePath().toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        DEFAULT_BASE_PATH = dir;
    }

    public class ThreadLocalData {
        public final ExcerptAppender appender;
        public final ExcerptTailer tailer;
        public final ExcerptTailer replayTailer;
        public M element;

        public ThreadLocalData(ChronicleQueue chronicleQueue) {
            try {
                this.appender = chronicleQueue.createAppender();
                this.tailer = chronicleQueue.createTailer();
                this.replayTailer = chronicleQueue.createTailer();
            }
            catch (IOException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }
    }
}

