/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.time.LocalTime;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.network.ClientClosedProvider;
import net.openhft.chronicle.network.SessionMode;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaWireParser;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireParser;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SystemHandler
extends AbstractHandler
implements ClientClosedProvider {
    private final StringBuilder eventName = new StringBuilder();
    private SessionDetailsProvider sessionDetails;
    private final WireParser wireParser = this.wireParser();
    @Nullable
    private Map<String, UserStat> monitoringMap;
    private volatile boolean hasClientClosed;
    private boolean wasHeartBeat;
    @NotNull
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, tid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        if (EventId.userId.contentEquals(this.eventName)) {
            this.sessionDetails.setUserId(valueIn.text());
            if (this.monitoringMap != null) {
                UserStat userStat = new UserStat();
                userStat.setLoggedIn(LocalTime.now());
                this.monitoringMap.put(this.sessionDetails.userId(), userStat);
            }
            while (inWire.bytes().readRemaining() > 0L) {
                this.wireParser.parse(inWire);
            }
            return;
        }
        if (!EventId.heartbeat.contentEquals(this.eventName) && !EventId.onClientClosing.contentEquals(this.eventName)) {
            return;
        }
        this.wasHeartBeat = true;
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(tid.longValue()));
        this.writeData(inWire.bytes(), out -> {
            if (EventId.heartbeat.contentEquals(this.eventName)) {
                this.outWire.write((WireKey)EventId.heartbeatReply).int64(valueIn.int64());
            } else if (EventId.onClientClosing.contentEquals(this.eventName)) {
                this.hasClientClosed = true;
                this.outWire.write((WireKey)EventId.onClosingReply).text((CharSequence)"");
            }
        });
    };

    public boolean wasHeartBeat() {
        return this.wasHeartBeat;
    }

    void process(@NotNull WireIn inWire, @NotNull WireOut outWire, long tid, @NotNull SessionDetailsProvider sessionDetails, @Nullable Map<String, UserStat> monitoringMap) {
        this.wasHeartBeat = false;
        this.sessionDetails = sessionDetails;
        this.monitoringMap = monitoringMap;
        this.setOutWire(outWire);
        this.dataConsumer.accept(inWire, tid);
    }

    private WireParser wireParser() {
        VanillaWireParser parser = new VanillaWireParser();
        parser.register(() -> EventId.domain.toString(), v -> v.text((Object)this, (o, x) -> o.sessionDetails.setDomain(x)));
        parser.register(() -> EventId.sessionMode.toString(), v -> v.text((Object)this, (o, x) -> o.sessionDetails.setSessionMode(SessionMode.valueOf((String)x))));
        parser.register(() -> EventId.securityToken.toString(), v -> v.text((Object)this, (o, x) -> o.sessionDetails.setSecurityToken(x)));
        parser.register(() -> EventId.clientId.toString(), v -> v.text((Object)this, (o, x) -> o.sessionDetails.setClientId(UUID.fromString(x))));
        parser.register(() -> "", v -> {});
        return parser;
    }

    public boolean hasClientClosed() {
        return this.hasClientClosed;
    }

    public static enum EventId implements WireKey
    {
        heartbeat,
        heartbeatReply,
        onClientClosing,
        onClosingReply,
        userId,
        sessionMode,
        domain,
        securityToken,
        clientId;

    }
}

