/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import java.util.function.Function;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PublisherHandler<E>
extends AbstractHandler {
    private final StringBuilder eventName = new StringBuilder();
    private WireOutPublisher publisher;
    private Publisher<E> view;
    @Nullable
    private Function<ValueIn, E> wireToE;
    private final BiConsumer<WireIn, Long> dataConsumer = new BiConsumer<WireIn, Long>(){

        @Override
        public void accept(@NotNull WireIn inWire, Long inputTid) {
            PublisherHandler.this.eventName.setLength(0);
            ValueIn valueIn = inWire.readEventName(PublisherHandler.this.eventName);
            if (EventId.registerSubscriber.contentEquals(PublisherHandler.this.eventName)) {
                Publisher key = PublisherHandler.this.view;
                Subscriber<Object> listener = message -> {
                    WireOutPublisher wireOutPublisher = PublisherHandler.this.publisher;
                    synchronized (wireOutPublisher) {
                        PublisherHandler.this.publisher.put(key, publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
                            publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> m.write((WireKey)Params.message).object(message)));
                        });
                    }
                };
                boolean bootstrap = true;
                valueIn.marshallable(m -> PublisherHandler.this.view.registerSubscriber(bootstrap, PublisherHandler.this.requestContext.throttlePeriodMs(), listener));
                return;
            }
            PublisherHandler.this.outWire.writeDocument(true, wire -> PublisherHandler.this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
            PublisherHandler.this.writeData(inWire.bytes(), out -> {
                if (EventId.publish.contentEquals(PublisherHandler.this.eventName)) {
                    valueIn.marshallable(wire -> {
                        Params[] params = (Params[])EventId.publish.params();
                        Object message = PublisherHandler.this.wireToE.apply(wire.read((WireKey)params[1]));
                        AbstractHandler.nullCheck(message);
                        PublisherHandler.this.view.publish(message);
                    });
                }
            });
        }
    };

    void process(@NotNull WireIn inWire, @NotNull RequestContext requestContext, @NotNull WireOutPublisher publisher, long tid, @NotNull Publisher view, @NotNull Wire outWire, @NotNull WireAdapter wireAdapter) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.publisher = publisher;
        this.view = view;
        this.wireToE = wireAdapter.wireToValue();
        this.requestContext = requestContext;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        publish(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]),
        registerSubscriber((WireKey[])new Params[]{Params.message});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    public static enum Params implements WireKey
    {
        message;

    }
}

