/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.util.function.BiConsumer;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.server.internal.SubscriptionHandler;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ObjectKVSubscriptionHandler
extends SubscriptionHandler<SubscriptionCollection> {
    private static final Logger LOG = LoggerFactory.getLogger(ObjectKVSubscriptionHandler.class);
    @NotNull
    private final BiConsumer<WireIn, Long> dataConsumer = (inWire, inputTid) -> {
        this.eventName.setLength(0);
        ValueIn valueIn = inWire.readEventName(this.eventName);
        if (EventId.registerTopicSubscriber.contentEquals(this.eventName)) {
            if (this.tidToListener.containsKey(CoreFields.tid)) {
                LOG.info("Duplicate topic registration for tid " + CoreFields.tid);
                return;
            }
            TopicSubscriber listener = new TopicSubscriber((Long)inputTid){
                volatile boolean subscriptionEnded;
                final /* synthetic */ Long val$inputTid;
                {
                    this.val$inputTid = l;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onMessage(Object topic, Object message) {
                    WireOutPublisher wireOutPublisher = ObjectKVSubscriptionHandler.this.publisher;
                    synchronized (wireOutPublisher) {
                        ObjectKVSubscriptionHandler.this.publisher.put(topic, publish -> {
                            publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                            publish.writeNotReadyDocument(false, wire -> wire.writeEventName((WireKey)CoreFields.reply).marshallable(m -> {
                                m.write(() -> "topic").object(topic);
                                m.write(() -> "message").object(message);
                            }));
                        });
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onEndOfSubscription() {
                    this.subscriptionEnded = true;
                    WireOutPublisher wireOutPublisher = ObjectKVSubscriptionHandler.this.publisher;
                    synchronized (wireOutPublisher) {
                        if (!ObjectKVSubscriptionHandler.this.publisher.isClosed()) {
                            ObjectKVSubscriptionHandler.this.publisher.put(null, publish -> {
                                publish.writeDocument(true, wire -> wire.writeEventName((WireKey)CoreFields.tid).int64(this.val$inputTid.longValue()));
                                publish.writeDocument(false, wire -> wire.writeEventName((WireKey)EventId.onEndOfSubscription).text((CharSequence)""));
                            });
                        }
                    }
                }
            };
            valueIn.marshallable(m -> {
                Class kClass = m.read(() -> "keyType").typeLiteral();
                Class vClass = m.read(() -> "valueType").typeLiteral();
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn bootstrap = m.readEventName(eventName);
                this.tidToListener.put(inputTid, listener);
                if ("bootstrap".contentEquals(eventName)) {
                    this.assetTree.registerTopicSubscriber(this.requestContext.fullName() + "?bootstrap=" + bootstrap.bool(), kClass, vClass, listener);
                } else {
                    this.assetTree.registerTopicSubscriber(this.requestContext.fullName(), kClass, vClass, listener);
                }
            });
            return;
        }
        if (EventId.unregisterTopicSubscriber.contentEquals(this.eventName)) {
            TopicSubscriber listener = (TopicSubscriber)this.tidToListener.remove(inputTid);
            if (listener == null) {
                LOG.warn("No subscriber to present to unsubscribe (" + inputTid + ")");
                return;
            }
            this.assetTree.unregisterTopicSubscriber(this.requestContext.fullName(), listener);
            return;
        }
        if (this.before((Long)inputTid, valueIn)) {
            return;
        }
        this.outWire.writeDocument(true, wire -> this.outWire.writeEventName((WireKey)CoreFields.tid).int64(inputTid.longValue()));
        this.writeData(inWire.bytes(), out -> {
            if (this.after(this.eventName)) {
                return;
            }
            if (EventId.notifyEvent.contentEquals(this.eventName)) {
                ((ObjectSubscription)this.subscription).notifyEvent((MapEvent)valueIn.typedMarshallable());
                this.outWire.writeEventName((WireKey)CoreFields.reply).int8((long)this.subscription.entrySubscriberCount());
            }
        });
    };

    @Override
    protected void unregisterAll() {
        this.tidToListener.forEach((k, listener) -> {
            if (listener instanceof TopicSubscriber) {
                this.assetTree.unregisterTopicSubscriber(this.requestContext.fullName(), (TopicSubscriber)listener);
            } else {
                this.assetTree.unregisterSubscriber(this.requestContext.fullName(), (Subscriber)listener);
            }
        });
        this.tidToListener.clear();
    }

    void process(@NotNull WireIn inWire, @NotNull RequestContext requestContext, @NotNull WireOutPublisher publisher, @NotNull AssetTree assetTree, long tid, @NotNull Wire outWire, @NotNull SubscriptionCollection subscription) {
        this.setOutWire((WireOut)outWire);
        this.outWire = outWire;
        this.subscription = subscription;
        this.requestContext = requestContext;
        this.publisher = this.publisher(publisher);
        this.assetTree = assetTree;
        this.dataConsumer.accept(inWire, tid);
    }

    public static enum EventId implements ParameterizeWireKey
    {
        registerTopicSubscriber(new WireKey[0]),
        unregisterTopicSubscriber(new WireKey[0]),
        onEndOfSubscription(new WireKey[0]),
        notifyEvent(new WireKey[0]);

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }
}

