/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.engine.api.collection.ValuesCollection;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Replication;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionCollection;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.session.Heartbeat;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.set.KeySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.api.tree.RequestContextInterner;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.server.internal.AbstractHandler;
import net.openhft.chronicle.engine.server.internal.GenericWireAdapter;
import net.openhft.chronicle.engine.server.internal.MapWireHandler;
import net.openhft.chronicle.engine.server.internal.ObjectKVSubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.ReferenceHandler;
import net.openhft.chronicle.engine.server.internal.ReplicationHandler;
import net.openhft.chronicle.engine.server.internal.SystemHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.engine.server.internal.TopologySubscriptionHandler;
import net.openhft.chronicle.engine.server.internal.WireAdapter;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.TopologySubscription;
import net.openhft.chronicle.network.ClientClosedProvider;
import net.openhft.chronicle.network.WireTcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineWireHandler
extends WireTcpHandler
implements ClientClosedProvider {
    private static final Logger LOG = LoggerFactory.getLogger(EngineWireHandler.class);
    private final StringBuilder cspText = new StringBuilder();
    @NotNull
    private final CollectionWireHandler keySetHandler;
    @NotNull
    private final MapWireHandler mapWireHandler;
    @NotNull
    private final CollectionWireHandler entrySetHandler;
    @NotNull
    private final CollectionWireHandler valuesHandler;
    @NotNull
    private final ObjectKVSubscriptionHandler subscriptionHandler;
    @NotNull
    private final TopologySubscriptionHandler topologySubscriptionHandler;
    @NotNull
    private final TopicPublisherHandler topicPublisherHandler;
    @NotNull
    private final PublisherHandler publisherHandler;
    @NotNull
    private final ReferenceHandler referenceHandler;
    @NotNull
    private final ReplicationHandler replicationHandler;
    @NotNull
    private final AssetTree assetTree;
    @NotNull
    private final ReadMarshallable metaDataConsumer;
    private final StringBuilder lastCsp = new StringBuilder();
    private final StringBuilder eventName = new StringBuilder();
    @NotNull
    private final SystemHandler systemHandler;
    @Nullable
    private final SessionProvider sessionProvider;
    @Nullable
    private final HostIdentifier hostIdentifier;
    @Nullable
    private final EventLoop eventLoop;
    private final RequestContextInterner requestContextInterner = new RequestContextInterner(128);
    private final StringBuilder currentLogMessage = new StringBuilder();
    private final StringBuilder prevLogMessage = new StringBuilder();
    private WireAdapter wireAdapter;
    private Object view;
    private boolean isSystemMessage = true;
    private RequestContext requestContext;
    @Nullable
    private Class viewType;
    private long tid;

    public EngineWireHandler(@NotNull WireType byteToWire, @NotNull AssetTree assetTree) {
        super((Function)byteToWire);
        this.sessionProvider = assetTree.root().getView(SessionProvider.class);
        this.eventLoop = assetTree.root().findOrCreateView(EventLoop.class);
        assert (this.eventLoop != null);
        try {
            this.eventLoop.start();
        }
        catch (RejectedExecutionException e) {
            LOG.debug("", (Throwable)e);
        }
        this.hostIdentifier = assetTree.root().findOrCreateView(HostIdentifier.class);
        this.assetTree = assetTree;
        this.mapWireHandler = new MapWireHandler();
        this.metaDataConsumer = this.wireInConsumer();
        this.keySetHandler = new CollectionWireHandler();
        this.entrySetHandler = new CollectionWireHandler();
        this.valuesHandler = new CollectionWireHandler();
        this.subscriptionHandler = new ObjectKVSubscriptionHandler();
        this.topologySubscriptionHandler = new TopologySubscriptionHandler();
        this.topicPublisherHandler = new TopicPublisherHandler();
        this.publisherHandler = new PublisherHandler();
        this.referenceHandler = new ReferenceHandler();
        this.replicationHandler = new ReplicationHandler();
        this.systemHandler = new SystemHandler();
    }

    public void onEndOfConnection(boolean heartbeatTimeOut) {
        for (AbstractHandler abstractHandler : new AbstractHandler[]{this.mapWireHandler, this.subscriptionHandler, this.topologySubscriptionHandler, this.publisherHandler, this.replicationHandler}) {
            abstractHandler.onEndOfConnection(heartbeatTimeOut);
        }
        Jvm.pause((long)100L);
    }

    @NotNull
    private ReadMarshallable wireInConsumer() {
        return wire -> {
            block10: {
                long startWritePosition = this.outWire.bytes().writePosition();
                boolean bl = this.isSystemMessage = wire.bytes().readRemaining() == 0L;
                if (this.isSystemMessage) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("received system-meta-data");
                    }
                    return;
                }
                try {
                    this.readCsp(wire);
                    this.readTid(wire);
                }
                catch (Throwable t) {
                    Jvm.rethrow((Throwable)t);
                }
                try {
                    if (!this.hasCspChanged(this.cspText)) break block10;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("received meta-data:\n" + wire.bytes().toHexString());
                    }
                    this.requestContext = this.requestContextInterner.intern(this.cspText);
                    this.viewType = this.requestContext.viewType();
                    if (this.viewType == null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("received system-meta-data");
                        }
                        this.isSystemMessage = true;
                        return;
                    }
                    this.view = this.assetTree.acquireView(this.requestContext);
                    if (this.viewType == MapView.class || this.viewType == EntrySetView.class || this.viewType == ValuesCollection.class || this.viewType == KeySetView.class || this.viewType == ObjectSubscription.class || this.viewType == TopicPublisher.class || this.viewType == Publisher.class || this.viewType == Reference.class || this.viewType == TopologySubscription.class || this.viewType == Replication.class || this.viewType == Heartbeat.class) {
                        Class type = this.requestContext.keyType() == null ? String.class : this.requestContext.keyType();
                        Class type2 = this.requestContext.valueType() == null ? String.class : this.requestContext.valueType();
                        this.wireAdapter = new GenericWireAdapter(type, type2);
                        break block10;
                    }
                    throw new UnsupportedOperationException("unsupported view type");
                }
                catch (Throwable e) {
                    LOG.error("", e);
                    this.outWire.bytes().writePosition(startWritePosition);
                    this.outWire.writeDocument(true, w -> w.writeEventName((WireKey)CoreFields.tid).int64(this.tid));
                    this.outWire.writeDocument(false, out -> out.writeEventName(() -> "exception").throwable(e));
                    this.logYamlToStandardOut((WireIn)this.outWire);
                    Jvm.rethrow((Throwable)e);
                }
            }
        };
    }

    private boolean hasCspChanged(@NotNull StringBuilder cspText) {
        boolean result;
        boolean bl = result = !cspText.equals(this.lastCsp);
        if (result) {
            this.lastCsp.setLength(0);
            this.lastCsp.append((CharSequence)cspText);
        }
        return result;
    }

    private void readTid(@NotNull WireIn metaDataWire) {
        ValueIn valueIn = metaDataWire.readEventName(this.eventName);
        if (CoreFields.tid.contentEquals((CharSequence)this.eventName)) {
            this.tid = valueIn.int64();
            this.eventName.setLength(0);
        } else {
            this.tid = -1L;
        }
    }

    protected void process(@NotNull WireIn in, @NotNull WireOut out, @NotNull SessionDetailsProvider sessionDetails) {
        if (!YamlLogging.showHeartBeats) {
            this.prevLogMessage.setLength(0);
            this.prevLogMessage.append((CharSequence)this.currentLogMessage);
            this.currentLogMessage.setLength(0);
            this.logToBuffer(in, this.currentLogMessage);
        } else {
            this.logYamlToStandardOut(in);
        }
        if (this.sessionProvider != null) {
            this.sessionProvider.set((SessionDetails)sessionDetails);
        }
        in.readDocument(this.metaDataConsumer, wire -> {
            try {
                Map<String, UserStat> userMonitoringMap;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("received data:\n" + wire.bytes().toHexString());
                }
                if (this.isSystemMessage) {
                    this.systemHandler.process(in, out, this.tid, sessionDetails, this.getMonitoringMap());
                    if (!this.systemHandler.wasHeartBeat() && !YamlLogging.showHeartBeats) {
                        this.logBufferToStandardOut(this.prevLogMessage.append((CharSequence)this.currentLogMessage));
                    }
                    return;
                }
                if (!YamlLogging.showHeartBeats) {
                    this.logBufferToStandardOut(this.prevLogMessage.append((CharSequence)this.currentLogMessage));
                }
                if ((userMonitoringMap = this.getMonitoringMap()) != null) {
                    UserStat userStat = userMonitoringMap.get(sessionDetails.userId());
                    if (userStat == null) {
                        throw new AssertionError((Object)"User should have been logged in");
                    }
                    userStat.setRecentInteraction(LocalTime.now());
                    userStat.setTotalInteractions(userStat.getTotalInteractions() + 1);
                    userMonitoringMap.put(sessionDetails.userId(), userStat);
                }
                if (this.wireAdapter != null) {
                    if (this.viewType == MapView.class) {
                        this.mapWireHandler.process(in, out, (MapView)this.view, this.tid, this.wireAdapter, this.requestContext);
                        return;
                    }
                    if (this.viewType == EntrySetView.class) {
                        this.entrySetHandler.process(in, out, (EntrySetView)this.view, this.wireAdapter.entryToWire(), this.wireAdapter.wireToEntry(), HashSet::new, this.tid);
                        return;
                    }
                    if (this.viewType == KeySetView.class) {
                        this.keySetHandler.process(in, out, (KeySetView)this.view, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), HashSet::new, this.tid);
                        return;
                    }
                    if (this.viewType == ValuesCollection.class) {
                        this.valuesHandler.process(in, out, (ValuesCollection)this.view, this.wireAdapter.keyToWire(), this.wireAdapter.wireToKey(), ArrayList::new, this.tid);
                        return;
                    }
                    if (this.viewType == ObjectSubscription.class) {
                        this.subscriptionHandler.process(in, this.requestContext, this.publisher, this.assetTree, this.tid, this.outWire, (SubscriptionCollection)this.view);
                        return;
                    }
                    if (this.viewType == TopologySubscription.class) {
                        this.topologySubscriptionHandler.process(in, this.requestContext, this.publisher, this.assetTree, this.tid, this.outWire, (TopologySubscription)this.view);
                        return;
                    }
                    if (this.viewType == Reference.class) {
                        this.referenceHandler.process(in, this.requestContext, this.publisher, this.tid, (Reference)this.view, this.cspText, this.outWire, this.wireAdapter);
                        return;
                    }
                    if (this.viewType == TopicPublisher.class) {
                        this.topicPublisherHandler.process(in, this.publisher, this.tid, this.outWire, (TopicPublisher)this.view, this.wireAdapter);
                        return;
                    }
                    if (this.viewType == Publisher.class) {
                        this.publisherHandler.process(in, this.requestContext, this.publisher, this.tid, (Publisher)this.view, this.outWire, this.wireAdapter);
                        return;
                    }
                    if (this.viewType == Replication.class) {
                        this.replicationHandler.process(in, this.publisher, this.tid, this.outWire, this.hostIdentifier, (Replication)this.view, this.eventLoop);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                if (this.sessionProvider != null) {
                    this.sessionProvider.remove();
                }
            }
        });
    }

    private Map<String, UserStat> getMonitoringMap() {
        Map userMonitoringMap = null;
        Asset userAsset = this.assetTree.root().getAsset("proc/users");
        if (userAsset != null && userAsset.getView(MapView.class) != null) {
            userMonitoringMap = userAsset.getView(MapView.class);
        }
        return userMonitoringMap;
    }

    private void logYamlToStandardOut(@NotNull WireIn in) {
        if (YamlLogging.showServerReads) {
            try {
                LOG.info("\nServer Receives:\n" + Wires.fromSizePrefixedBlobs((Bytes)in.bytes()));
            }
            catch (Exception e) {
                LOG.info("\n\n" + Bytes.toString((Bytes)in.bytes()));
            }
        }
    }

    private void logToBuffer(@NotNull WireIn in, StringBuilder logBuffer) {
        if (YamlLogging.showServerReads) {
            logBuffer.setLength(0);
            try {
                logBuffer.append("\nServer Receives:\n").append(Wires.fromSizePrefixedBlobs((Bytes)in.bytes()));
            }
            catch (Exception e) {
                logBuffer.append("\n\n" + Bytes.toString((Bytes)in.bytes()));
            }
        }
    }

    private void logBufferToStandardOut(StringBuilder logBuffer) {
        if (logBuffer.length() > 0) {
            LOG.info("\n" + logBuffer.toString());
        }
    }

    private void readCsp(@NotNull WireIn wireIn) {
        StringBuilder keyName = Wires.acquireStringBuilder();
        this.cspText.setLength(0);
        ValueIn read = wireIn.readEventName(keyName);
        if (CoreFields.csp.contentEquals((CharSequence)keyName)) {
            read.textTo(this.cspText);
        } else if (CoreFields.cid.contentEquals((CharSequence)keyName)) {
            long cid = read.int64();
            CharSequence s = this.mapWireHandler.getCspForCid(cid);
            this.cspText.append(s);
        }
    }

    public boolean hasClientClosed() {
        return this.systemHandler.hasClientClosed();
    }

    public void close() {
        this.onEndOfConnection(false);
        this.publisher.close();
    }
}

