/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server.internal;

import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandler.class);
    @Nullable
    WireOut outWire = null;
    volatile boolean connectionClosed = false;
    RequestContext requestContext;

    AbstractHandler() {
    }

    static void nullCheck(@Nullable Object o) {
        if (o == null) {
            throw new NullPointerException();
        }
    }

    void setOutWire(@NotNull WireOut outWire) {
        this.outWire = outWire;
    }

    void writeData(@NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        this.outWire.writeDocument(false, out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable(this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        });
        this.logYaml();
    }

    void writeData(boolean isNotReady, @NotNull Bytes inBytes, @NotNull WriteMarshallable c) {
        WriteMarshallable marshallable = out -> {
            long readPosition = inBytes.readPosition();
            long position = this.outWire.bytes().writePosition();
            try {
                c.writeMarshallable(this.outWire);
            }
            catch (Throwable t) {
                inBytes.readPosition(readPosition);
                if (LOG.isInfoEnabled()) {
                    LOG.info("While reading " + inBytes.toDebugString(), (Object)(" processing wire " + c), (Object)t);
                }
                this.outWire.bytes().writePosition(position);
                this.outWire.writeEventName(() -> "exception").throwable(t);
            }
            if (position == this.outWire.bytes().writePosition()) {
                this.outWire.writeEventName((WireKey)CoreFields.reply).marshallable(WriteMarshallable.EMPTY);
            }
        };
        if (isNotReady) {
            this.outWire.writeNotReadyDocument(false, marshallable);
        } else {
            this.outWire.writeDocument(false, marshallable);
        }
        this.logYaml();
    }

    private void logYaml() {
        if (YamlLogging.showServerWrites) {
            try {
                LOG.info("\nServer Sends:\n" + Wires.fromSizePrefixedBlobs((Bytes)this.outWire.bytes()));
            }
            catch (Exception e) {
                LOG.info("\nServer Sends ( corrupted ) :\n" + this.outWire.bytes().toDebugString());
            }
        }
    }

    public void onEndOfConnection(boolean heartbeatTimeOut) {
        this.connectionClosed = true;
        this.unregisterAll();
    }

    protected void unregisterAll() {
    }

    WireOutPublisher publisher(WireOutPublisher publisher) {
        return this.requestContext.throttlePeriodMs() == 0 ? publisher : WireOutPublisher.newThrottledWireOutPublisher((int)this.requestContext.throttlePeriodMs(), (WireOutPublisher)publisher);
    }
}

