/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.server;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.server.internal.EngineWireHandler;
import net.openhft.chronicle.network.AcceptorEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.threads.Threads;
import net.openhft.chronicle.threads.api.EventHandler;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerEndpoint
implements Closeable {
    public static final int HEARTBEAT_INTERVAL_TICKS = Integer.getInteger("heartbeat.interval.ticks", 500);
    public static final int HEARTBEAT_TIME_OUT_TICKS = Integer.getInteger("heartbeat.timeout.ticks", 10000);
    private static final Logger LOGGER = LoggerFactory.getLogger(ChronicleMapKeyValueStore.class);
    @Nullable
    private final EventLoop eg;
    @NotNull
    private final AtomicBoolean isClosed = new AtomicBoolean();
    private final int heartbeatIntervalTicks;
    private final int heartbeatIntervalTimeout;
    @Nullable
    private AcceptorEventHandler eah;

    public ServerEndpoint(String hostPortDescription, @NotNull AssetTree assetTree, @NotNull WireType wire) {
        this(hostPortDescription, assetTree, wire, HEARTBEAT_INTERVAL_TICKS, HEARTBEAT_TIME_OUT_TICKS);
    }

    public ServerEndpoint(@NotNull String hostPortDescription, @NotNull AssetTree assetTree, @NotNull WireType wire, int heartbeatIntervalTicks, int heartbeatIntervalTimeout) {
        this.heartbeatIntervalTicks = heartbeatIntervalTicks;
        this.heartbeatIntervalTimeout = heartbeatIntervalTimeout;
        this.eg = assetTree.root().acquireView(EventLoop.class);
        Threads.withThreadGroup((ThreadGroup)assetTree.root().getView(ThreadGroup.class), () -> {
            this.start(hostPortDescription, assetTree, wire);
            return null;
        });
    }

    @Nullable
    private AcceptorEventHandler start(@NotNull String hostPortDescription, @NotNull AssetTree asset, @NotNull WireType wireType) throws IOException {
        assert (this.eg != null);
        this.eg.start();
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("starting server=" + hostPortDescription);
        }
        EventLoop eventLoop = asset.root().findOrCreateView(EventLoop.class);
        assert (eventLoop != null);
        AcceptorEventHandler eah = new AcceptorEventHandler(hostPortDescription, () -> new EngineWireHandler(wireType, asset), VanillaSessionDetails::new, (long)this.heartbeatIntervalTicks, (long)this.heartbeatIntervalTimeout);
        this.eg.addHandler((EventHandler)eah);
        this.eah = eah;
        return eah;
    }

    private void stop() {
        if (this.eg != null) {
            this.eg.stop();
        }
    }

    public void close() {
        this.isClosed.set(true);
        this.stop();
        Closeable.closeQuietly((Object)this.eah);
        this.eah = null;
    }
}

