/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.query;

import net.openhft.chronicle.core.annotation.NotNull;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;

public class Operation
implements Marshallable {
    private OperationType type;
    private Object wrapped;

    public Operation() {
    }

    public Operation(@NotNull OperationType type, @NotNull Object wrapped) {
        this.type = type;
        this.wrapped = wrapped;
    }

    public OperationType op() {
        return this.type;
    }

    public <T> T wrapped() {
        return (T)this.wrapped;
    }

    public void readMarshallable(WireIn wireIn) throws IllegalStateException {
        this.type = OperationType.valueOf(wireIn.read(() -> "type").text());
        this.wrapped = wireIn.read(() -> "wrapped").object(Object.class);
    }

    public void writeMarshallable(WireOut wireOut) {
        wireOut.write(() -> "type").text((CharSequence)this.type.toString());
        wireOut.write(() -> "wrapped").object(this.wrapped);
    }

    public String toString() {
        return "Operation{type=" + (Object)((Object)this.type) + ", wrapped=" + this.wrapped + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Operation)) {
            return false;
        }
        Operation operation = (Operation)o;
        if (this.type != operation.type) {
            return false;
        }
        return !(this.wrapped == null ? operation.wrapped != null : !this.wrapped.equals(operation.wrapped));
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.wrapped != null ? this.wrapped.hashCode() : 0);
        return result;
    }

    public static enum OperationType {
        MAP,
        FILTER,
        PROJECT,
        FLAT_MAP;

    }
}

