/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.Assetted;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.server.internal.PublisherHandler;
import net.openhft.chronicle.engine.server.internal.TopicPublisherHandler;
import net.openhft.chronicle.network.connection.AbstractAsyncSubscription;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.AsyncSubscription;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteTopicPublisher<T, M>
extends AbstractStatelessClient<TopicPublisherHandler.EventId>
implements TopicPublisher<T, M>,
Assetted<MapView<T, M>> {
    private final MapView<T, M> underlying;
    private final Class<T> topicClass;
    private final Class<M> messageClass;
    private final Asset asset;

    public RemoteTopicPublisher(@NotNull RequestContext context, @NotNull Asset asset, MapView<T, M> underlying) throws AssetNotFoundException {
        super(asset.findView(TcpChannelHub.class), 0L, RemoteTopicPublisher.toUri(context));
        this.asset = asset;
        this.underlying = underlying;
        this.topicClass = context.topicType();
        this.messageClass = context.messageType();
    }

    private static String toUri(@NotNull RequestContext context) {
        StringBuilder uri = new StringBuilder("/" + context.fullName() + "?view=" + "topicPublisher");
        if (context.keyType() != String.class) {
            uri.append("&topicType=").append(context.topicType().getName());
        }
        if (context.valueType() != String.class) {
            uri.append("&messageType=").append(context.messageType().getName());
        }
        return uri.toString();
    }

    @Override
    public void publish(@NotNull T topic, @NotNull M message) {
        this.checkTopic(topic);
        this.checkMessage(message);
        this.sendEventAsync((WireKey)TopicPublisherHandler.EventId.publish, valueOut -> valueOut.marshallable(m -> {
            m.write((WireKey)TopicPublisherHandler.Params.topic).object(topic);
            m.write((WireKey)TopicPublisherHandler.Params.message).object(message);
        }), true);
    }

    private void checkTopic(@Nullable Object topic) {
        if (topic == null) {
            throw new NullPointerException("topic can not be null");
        }
    }

    private void checkMessage(@Nullable Object message) {
        if (message == null) {
            throw new NullPointerException("message can not be null");
        }
    }

    @Override
    public void registerTopicSubscriber(final @NotNull TopicSubscriber<T, M> topicSubscriber) throws AssetNotFoundException {
        if (this.hub.outBytesLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("Cannot view map while debugging");
        }
        this.hub.subscribe((AsyncSubscription)new AbstractAsyncSubscription(this.hub, this.csp, "Remote Topic publisher register subscribe"){

            public void onSubscribe(@NotNull WireOut wireOut) {
                wireOut.writeEventName((WireKey)PublisherHandler.EventId.registerSubscriber).text((CharSequence)"");
            }

            public void onConsumer(@NotNull WireIn w) {
                w.readDocument(null, d -> {
                    StringBuilder eventname = Wires.acquireStringBuilder();
                    ValueIn valueIn = d.readEventName(eventname);
                    if (TopicPublisherHandler.EventId.onEndOfSubscription.contentEquals(eventname)) {
                        topicSubscriber.onEndOfSubscription();
                        RemoteTopicPublisher.this.hub.unsubscribe(this.tid());
                    } else if (CoreFields.reply.contentEquals((CharSequence)eventname)) {
                        valueIn.marshallable(m -> {
                            Object topic = m.read(() -> "topic").object(RemoteTopicPublisher.this.topicClass);
                            Object message = m.read(() -> "message").object(RemoteTopicPublisher.this.messageClass);
                            RemoteTopicPublisher.this.onEvent(topic, message, topicSubscriber);
                        });
                    }
                });
            }
        });
    }

    @Override
    public void unregisterTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Publisher<M> publisher(@NotNull T topic) {
        throw new UnsupportedOperationException("tood");
    }

    @Override
    public void registerSubscriber(@NotNull T topic, @NotNull Subscriber<M> subscriber) {
    }

    private void onEvent(T topic, @Nullable M message, @NotNull TopicSubscriber<T, M> topicSubscriber) {
        try {
            if (message != null) {
                topicSubscriber.onMessage(topic, message);
            }
        }
        catch (InvalidSubscriberException invalidSubscriberException) {
            // empty catch block
        }
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public MapView<T, M> underlying() {
        return this.underlying;
    }
}

