/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.engine.api.pubsub.Publisher;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.pubsub.TopicPublisher;
import net.openhft.chronicle.engine.api.pubsub.TopicSubscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.Assetted;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.KVSSubscription;
import net.openhft.chronicle.engine.tree.QueueView;
import org.jetbrains.annotations.NotNull;

public class QueueTopicPublisher<T, M>
implements TopicPublisher<T, M>,
Assetted<QueueView<T, M>> {
    private final Class<T> tClass;
    private final Class<M> mClass;
    private final Asset asset;
    private final QueueView<T, M> underlying;

    public QueueTopicPublisher(@NotNull RequestContext context, Asset asset, @NotNull QueueView<T, M> underlying) throws AssetNotFoundException {
        this(asset, context.type(), context.type2(), underlying);
    }

    QueueTopicPublisher(Asset asset, Class<T> tClass, Class<M> mClass, QueueView<T, M> underlying) {
        this.asset = asset;
        this.tClass = tClass;
        this.mClass = mClass;
        this.underlying = underlying;
    }

    @Override
    public void publish(@NotNull T topic, @NotNull M message) {
        this.underlying.set(topic, message);
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public QueueView<T, M> underlying() {
        return this.underlying;
    }

    @Override
    public void registerTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) throws AssetNotFoundException {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(true);
        subscription.registerTopicSubscriber(RequestContext.requestContext().bootstrap(true).type(this.tClass).type2(this.mClass), topicSubscriber);
    }

    @Override
    public void unregisterTopicSubscriber(@NotNull TopicSubscriber<T, M> topicSubscriber) {
        KVSSubscription subscription = (KVSSubscription)this.asset.subscription(false);
        if (subscription != null) {
            subscription.unregisterTopicSubscriber(topicSubscriber);
        }
    }

    @Override
    public Publisher<M> publisher(@NotNull T topic) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void registerSubscriber(@NotNull T topic, @NotNull Subscriber<M> subscriber) {
        throw new UnsupportedOperationException("todo");
    }
}

