/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.pubsub;

import net.openhft.chronicle.engine.api.pubsub.Reference;
import net.openhft.chronicle.engine.api.pubsub.Subscriber;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.tree.QueueView;
import org.jetbrains.annotations.Nullable;

public class QueueReference<T, M>
implements Reference<M> {
    private final Class<M> eClass;
    private final QueueView<T, M> chronicleQueue;
    private final T name;

    public QueueReference(Class type, QueueView<T, M> chronicleQueue, T name) {
        this.eClass = type;
        this.chronicleQueue = chronicleQueue;
        this.name = name;
    }

    public QueueReference(RequestContext requestContext, Asset asset, QueueView<T, M> queueView) {
        this(requestContext.type(), queueView, requestContext.name());
    }

    @Override
    public long set(M event) {
        return this.chronicleQueue.set(this.name, event);
    }

    @Override
    @Nullable
    public M get() {
        return this.chronicleQueue.get("");
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void registerSubscriber(boolean bootstrap, int throttlePeriodMs, Subscriber<M> subscriber) throws AssetNotFoundException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void unregisterSubscriber(Subscriber subscriber) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int subscriberCount() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Class getType() {
        return this.eClass;
    }
}

