/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.set.EntrySetView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetNotFoundException;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import org.jetbrains.annotations.NotNull;

public class VanillaEntrySetView<K, MV, V>
extends AbstractCollection<Map.Entry<K, V>>
implements EntrySetView<K, MV, V> {
    protected final MapView<K, V> mapView;
    private final Asset asset;

    public VanillaEntrySetView(RequestContext context, Asset asset, @NotNull MapView<K, V> mapView) throws AssetNotFoundException {
        this.asset = asset;
        this.mapView = mapView;
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> iterator() {
        return ((KeyValueStore)this.mapView.underlying()).entrySetIterator();
    }

    @Override
    public int size() {
        return this.mapView.size();
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public MapView<K, V> underlying() {
        return this.mapView;
    }

    @Override
    public int hashCode() {
        int h = 0;
        for (Map.Entry<K, V> entry : this) {
            h += entry.hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof Set)) {
            return false;
        }
        Set set = (Set)obj;
        if (set.size() != this.size()) {
            return false;
        }
        for (Map.Entry entry : set) {
            if (entry == null) {
                return false;
            }
            Object key = entry.getKey();
            if (key == null) {
                return false;
            }
            Object value = this.mapView.get(key);
            if (BytesUtil.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }
}

