/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.core.values.IntValue;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEventListener;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.lang.collection.ATSDirectBitSet;
import net.openhft.lang.collection.DirectBitSet;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.DirectStore;
import net.openhft.lang.model.Copyable;
import net.openhft.lang.model.DataValueClasses;
import net.openhft.lang.model.constraints.MaxSize;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaEngineReplication<K, V, MV, Store extends SubscriptionKeyValueStore<K, MV>>
implements EngineReplication,
Closeable {
    public static final int RESERVED_MOD_ITER = 8;
    public static final int MAX_MODIFICATION_ITERATORS = 135;
    public static final int DIRTY_WORD_COUNT = 3;
    @NotNull
    private static final ThreadLocal<Instances> threadLocalInstances = ThreadLocal.withInitial(Instances::new);
    private final KeyValueStore<BytesStore, ReplicationData>[] keyReplicationData;
    private final KeyValueStore<IntValue, RemoteNodeReplicationState> modIterState;
    private final byte identifier;
    @NotNull
    private final Store store;
    private final ChangeApplier<Store> changeApplier;
    private final GetValue<Store> getValue;
    private final SegmentForKey<Store> segmentForKey;
    private final AtomicReferenceArray<VanillaModificationIterator> modificationIterators = new AtomicReferenceArray(135);
    private final DirectBitSet modificationIteratorsRequiringSettingBootstrapTimestamp = VanillaEngineReplication.createModIterBitSet();
    private final DirectBitSet modIterSet = VanillaEngineReplication.createModIterBitSet();
    @NotNull
    private final MapEventListener<K, MV> eventListener;

    public VanillaEngineReplication(@NotNull IntFunction<KeyValueStore<BytesStore, ReplicationData>> obtainKeyReplicationDataBySegment, @NotNull KeyValueStore<IntValue, RemoteNodeReplicationState> modIterState, byte identifier, @NotNull Store store, ChangeApplier<Store> changeApplier, GetValue<Store> getValue, SegmentForKey<Store> segmentForKey, final @NotNull Function<K, BytesStore> keyToBytesStore) {
        int segments = store.segments();
        this.keyReplicationData = new KeyValueStore[segments];
        for (int i = 0; i < segments; ++i) {
            this.keyReplicationData[i] = obtainKeyReplicationDataBySegment.apply(i);
        }
        this.modIterState = modIterState;
        VanillaEngineReplication.initZeroStateForAllPossibleRemoteIdentifiers(modIterState);
        this.identifier = identifier;
        this.store = store;
        this.changeApplier = changeApplier;
        this.getValue = getValue;
        this.segmentForKey = segmentForKey;
        this.eventListener = new MapEventListener<K, MV>(){

            @Override
            public void insert(String assetName, K key, MV value) {
                VanillaEngineReplication.this.onPut((BytesStore)keyToBytesStore.apply(key), System.currentTimeMillis());
            }

            @Override
            public void remove(String assetName, K key, MV value) {
                VanillaEngineReplication.this.onRemove((BytesStore)keyToBytesStore.apply(key), System.currentTimeMillis());
            }

            @Override
            public void update(String assetName, K key, MV oldValue, MV newValue) {
                VanillaEngineReplication.this.onPut((BytesStore)keyToBytesStore.apply(key), System.currentTimeMillis());
            }
        };
        store.subscription(true).registerDownstream(e -> e.apply(this.eventListener));
    }

    private static int idToInt(byte identifier) {
        return identifier & 0xFF;
    }

    @NotNull
    private static DirectBitSet createModIterBitSet() {
        return ATSDirectBitSet.wrap((Bytes)new DirectStore(null, 24L, true).bytes());
    }

    private static void initZeroStateForAllPossibleRemoteIdentifiers(@NotNull KeyValueStore<IntValue, RemoteNodeReplicationState> modIterState) {
        Instances i = threadLocalInstances.get();
        for (int id = 0; id < 256; ++id) {
            i.identifier.setValue(id);
            modIterState.put(i.identifier, i.zeroState);
        }
    }

    private static boolean shouldApplyRemoteModification(@NotNull EngineReplication.ReplicationEntry remoteEntry, @NotNull ReplicationData localReplicationData) {
        long originTimestamp;
        long remoteTimestamp = remoteEntry.timestamp();
        return remoteTimestamp > (originTimestamp = localReplicationData.getTimestamp()) || remoteTimestamp == originTimestamp && remoteEntry.identifier() <= localReplicationData.getIdentifier();
    }

    @Override
    public byte identifier() {
        return this.identifier;
    }

    private void resetNextBootstrapTimestamp(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            i.copyState.copyFrom(i.usingState);
            i.copyState.setNextBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
    }

    private boolean setNextBootstrapTimestamp(int remoteIdentifier, long timestamp) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            if (i.usingState.getNextBootstrapTimestamp() != 0L) {
                return false;
            }
            i.copyState.copyFrom(i.usingState);
            i.copyState.setNextBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
        return true;
    }

    private void resetLastBootstrapTimestamp(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            i.copyState.copyFrom(i.usingState);
            i.copyState.setLastBootstrapTimestamp(0L);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
    }

    private long bootstrapTimestamp(int remoteIdentifier) {
        long nextBootstrapTs;
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        do {
            i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
            nextBootstrapTs = i.usingState.getNextBootstrapTimestamp();
            if (nextBootstrapTs == 0L) {
                return i.usingState.getLastBootstrapTimestamp();
            }
            i.copyState.copyFrom(i.usingState);
            i.copyState.setLastBootstrapTimestamp(nextBootstrapTs);
        } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
        return nextBootstrapTs;
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        return this.lastModificationTime(VanillaEngineReplication.idToInt(remoteIdentifier));
    }

    private long lastModificationTime(int remoteIdentifier) {
        Instances i = threadLocalInstances.get();
        i.identifier.setValue(remoteIdentifier);
        i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
        return i.usingState.getLastModificationTime();
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        this.setLastModificationTime(VanillaEngineReplication.idToInt(identifier), timestamp);
    }

    private void setLastModificationTime(int identifier, long timestamp) {
        block1: {
            Instances i = threadLocalInstances.get();
            i.identifier.setValue(identifier);
            do {
                i.usingState = this.modIterState.getUsing(i.identifier, i.usingState);
                if (i.usingState.getLastModificationTime() >= timestamp) break block1;
                i.copyState.copyFrom(i.usingState);
                i.copyState.setLastModificationTime(timestamp);
            } while (!this.modIterState.replaceIfEqual(i.identifier, i.usingState, i.copyState));
            return;
        }
    }

    @Override
    public void applyReplication(@NotNull EngineReplication.ReplicationEntry replicatedEntry) {
        Instances i = threadLocalInstances.get();
        BytesStore key = replicatedEntry.key();
        while (true) {
            boolean shouldApplyRemoteModification;
            KeyValueStore<BytesStore, ReplicationData> keyReplicationData;
            ReplicationData data;
            if ((data = (keyReplicationData = this.keyReplicationData[this.segmentForKey.segmentForKey(this.store, key)]).getUsing(key, i.usingData)) != null) {
                i.usingData = data;
            }
            if (!(shouldApplyRemoteModification = data == null || VanillaEngineReplication.shouldApplyRemoteModification(replicatedEntry, data))) continue;
            i.newData.copyFrom(data != null ? data : i.zeroData);
            this.changeApplier.applyChange(this.store, replicatedEntry);
            i.newData.setDeleted(replicatedEntry.isDeleted());
            i.newData.setIdentifier(replicatedEntry.identifier());
            i.newData.setTimestamp(replicatedEntry.timestamp());
            if (data == null) {
                if (keyReplicationData.putIfAbsent(key, i.newData) != null) continue;
                return;
            }
            ReplicationData.dropChange(i.newData);
            if (keyReplicationData.replaceIfEqual(key, data, i.newData)) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EngineReplication.ModificationIterator acquireModificationIterator(byte id) {
        int remoteIdentifier = VanillaEngineReplication.idToInt(id);
        EngineReplication.ModificationIterator modificationIterator = this.modificationIterators.get(remoteIdentifier);
        if (modificationIterator != null) {
            return modificationIterator;
        }
        AtomicReferenceArray<VanillaModificationIterator> atomicReferenceArray = this.modificationIterators;
        synchronized (atomicReferenceArray) {
            modificationIterator = this.modificationIterators.get(remoteIdentifier);
            if (modificationIterator != null) {
                return modificationIterator;
            }
            VanillaModificationIterator newModificationIterator = new VanillaModificationIterator(remoteIdentifier);
            this.modificationIteratorsRequiringSettingBootstrapTimestamp.set((long)remoteIdentifier);
            this.resetNextBootstrapTimestamp(remoteIdentifier);
            this.resetLastBootstrapTimestamp(remoteIdentifier);
            this.modificationIterators.set(remoteIdentifier, newModificationIterator);
            this.modIterSet.set((long)remoteIdentifier);
            return newModificationIterator;
        }
    }

    public void onPut(BytesStore key, long putTimestamp) {
        this.onChange(key, false, putTimestamp);
    }

    public void onRemove(BytesStore key, long removeTimestamp) {
        this.onChange(key, true, removeTimestamp);
    }

    private void onChange(BytesStore key, boolean deleted, long changeTimestamp) {
        boolean bl;
        boolean successfulUpdate;
        Instances i = threadLocalInstances.get();
        do {
            KeyValueStore<BytesStore, ReplicationData> keyReplicationData;
            ReplicationData data;
            if ((data = (keyReplicationData = this.keyReplicationData[this.segmentForKey.segmentForKey(this.store, key)]).getUsing(key, i.usingData)) != null) {
                i.usingData = data;
            }
            i.newData.copyFrom(data != null ? data : i.zeroData);
            i.newData.setDeleted(deleted);
            long entryTimestamp = i.newData.getTimestamp();
            if (entryTimestamp > changeTimestamp) {
                changeTimestamp = entryTimestamp + 1L;
            }
            i.newData.setTimestamp(changeTimestamp);
            i.newData.setIdentifier(this.identifier);
            ReplicationData.raiseChange(i.newData);
            if (data == null) {
                if (keyReplicationData.putIfAbsent(key, i.newData) == null) {
                    bl = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = keyReplicationData.replaceIfEqual(key, data, i.newData);
        } while (!(successfulUpdate = bl));
        long next = this.modIterSet.nextSetBit(0L);
        while (next > 0L) {
            VanillaModificationIterator modIter = this.modificationIterators.get((int)next);
            modIter.modNotify();
            if (this.modificationIteratorsRequiringSettingBootstrapTimestamp.clearIfSet(next) && !this.setNextBootstrapTimestamp((int)next, changeTimestamp)) {
                throw new AssertionError();
            }
            next = this.modIterSet.nextSetBit(next + 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        try {
            Throwable throwable = null;
            for (KeyValueStore<BytesStore, ReplicationData> keyReplicationData : this.keyReplicationData) {
                try {
                    keyReplicationData.close();
                }
                catch (Throwable e) {
                    if (throwable == null) {
                        throwable = e;
                        continue;
                    }
                    throwable.addSuppressed(e);
                }
            }
            if (throwable != null) {
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                throw (RuntimeException)throwable;
            }
        }
        finally {
            this.modIterState.close();
        }
    }

    class VanillaModificationIterator
    implements EngineReplication.ModificationIterator,
    EngineReplication.ReplicationEntry {
        private final int identifier;
        long forEachEntryCount;
        EngineReplication.ModificationNotifier modificationNotifier;
        @Nullable
        BytesStore key;
        @Nullable
        ReplicationData replicationData;

        VanillaModificationIterator(int identifier) {
            this.identifier = identifier;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean nextEntry(Consumer<EngineReplication.ReplicationEntry> consumer) {
            BytesStore key;
            Instances i = (Instances)threadLocalInstances.get();
            int count = VanillaEngineReplication.this.keyReplicationData.length;
            block3: while (true) {
                Iterator<BytesStore> keySetIterator = i.keySetIterator(VanillaEngineReplication.this.keyReplicationData);
                if (count == 0) {
                    VanillaEngineReplication.this.modificationIteratorsRequiringSettingBootstrapTimestamp.set((long)this.identifier);
                    VanillaEngineReplication.this.resetNextBootstrapTimestamp(this.identifier);
                    return false;
                }
                --count;
                Iterator<BytesStore> keyIt = keySetIterator;
                do {
                    if (!keyIt.hasNext()) continue block3;
                    key = keyIt.next();
                    i.usingData = i.keyReplicationData.getUsing(key, i.usingData);
                } while (!ReplicationData.isChanged(i.usingData, this.identifier));
                break;
            }
            this.key = key;
            this.replicationData = i.usingData;
            try {
                consumer.accept(this);
                i.newData.copyFrom(i.usingData);
                ReplicationData.clearChange(i.newData, this.identifier);
                if (!i.keyReplicationData.replaceIfEqual(key, i.usingData, i.newData)) {
                    throw new AssertionError();
                }
                boolean bl = true;
                return bl;
            }
            finally {
                this.key = null;
                this.replicationData = null;
            }
        }

        @Override
        public boolean hasNext() {
            Instances i = (Instances)threadLocalInstances.get();
            for (KeyValueStore keyReplicationData : VanillaEngineReplication.this.keyReplicationData) {
                Iterator keyIt = keyReplicationData.keySetIterator();
                while (keyIt.hasNext()) {
                    BytesStore key = (BytesStore)keyIt.next();
                    i.usingData = (ReplicationData)keyReplicationData.getUsing(key, i.usingData);
                    if (!ReplicationData.isChanged(i.usingData, this.identifier)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public void dirtyEntries(long fromTimeStamp) {
            Instances i = (Instances)threadLocalInstances.get();
            for (KeyValueStore keyReplicationData : VanillaEngineReplication.this.keyReplicationData) {
                keyReplicationData.keySetIterator().forEachRemaining(key -> {
                    instances.usingData = (ReplicationData)keyReplicationData.getUsing(key, instances.usingData);
                    if (instances.usingData.getTimestamp() >= fromTimeStamp) {
                        instances.newData.copyFrom(instances.usingData);
                        ReplicationData.setChange(instances.newData, this.identifier);
                        if (!keyReplicationData.replaceIfEqual(key, instances.usingData, instances.newData)) {
                            throw new AssertionError();
                        }
                    }
                });
            }
        }

        @Override
        public void setModificationNotifier(@NotNull EngineReplication.ModificationNotifier modificationNotifier) {
            this.modificationNotifier = modificationNotifier;
        }

        public void modNotify() {
            if (this.modificationNotifier != null) {
                this.modificationNotifier.onChange();
            }
        }

        @Override
        @Nullable
        public BytesStore key() {
            return this.key;
        }

        @Override
        @NotNull
        public BytesStore value() {
            return VanillaEngineReplication.this.getValue.getValue(VanillaEngineReplication.this.store, this.key);
        }

        @Override
        public long timestamp() {
            return this.replicationData.getTimestamp();
        }

        @Override
        public byte identifier() {
            return this.replicationData.getIdentifier();
        }

        @Override
        public byte remoteIdentifier() {
            throw new UnsupportedOperationException("todo");
        }

        @Override
        public boolean isDeleted() {
            return this.replicationData.getDeleted();
        }

        @Override
        public long bootStrapTimeStamp() {
            return VanillaEngineReplication.this.bootstrapTimestamp(this.identifier);
        }
    }

    static class Instances {
        final IntValue identifier = (IntValue)DataValueClasses.newInstance(IntValue.class);
        final RemoteNodeReplicationState copyState = (RemoteNodeReplicationState)DataValueClasses.newInstance(RemoteNodeReplicationState.class);
        final RemoteNodeReplicationState zeroState = (RemoteNodeReplicationState)DataValueClasses.newInstance(RemoteNodeReplicationState.class);
        final ReplicationData newData = (ReplicationData)DataValueClasses.newInstance(ReplicationData.class);
        final ReplicationData zeroData = (ReplicationData)DataValueClasses.newInstance(ReplicationData.class);
        @Nullable
        RemoteNodeReplicationState usingState = null;
        @Nullable
        ReplicationData usingData = null;
        int keyReplicationDataIndex = -1;
        KeyValueStore<BytesStore, ReplicationData> keyReplicationData;
        Iterator<BytesStore> keySetIterator;

        Instances() {
        }

        public Iterator<BytesStore> keySetIterator(KeyValueStore<BytesStore, ReplicationData>[] keyReplicationData) {
            if (this.keySetIterator != null && this.keySetIterator.hasNext()) {
                return this.keySetIterator;
            }
            this.keySetIterator = null;
            ++this.keyReplicationDataIndex;
            if (this.keyReplicationDataIndex == keyReplicationData.length) {
                this.keyReplicationDataIndex = 0;
            }
            this.keySetIterator = keyReplicationData[this.keyReplicationDataIndex].keySetIterator();
            return this.keySetIterator;
        }
    }

    public static interface RemoteNodeReplicationState
    extends Copyable<RemoteNodeReplicationState>,
    Marshallable {
        public long getNextBootstrapTimestamp();

        public void setNextBootstrapTimestamp(long var1);

        public long getLastBootstrapTimestamp();

        public void setLastBootstrapTimestamp(long var1);

        public long getLastModificationTime();

        public void setLastModificationTime(long var1);

        default public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
            this.setNextBootstrapTimestamp(wire.read(() -> "nextBootstrapTimestamp").int64());
            this.setLastBootstrapTimestamp(wire.read(() -> "lastBootstrapTimestamp").int64());
            this.setLastModificationTime(wire.read(() -> "lastModificationTime").int64());
        }

        default public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "nextBootstrapTimestamp").int64(this.getNextBootstrapTimestamp());
            wire.write(() -> "lastBootstrapTimestamp").int64(this.getLastBootstrapTimestamp());
            wire.write(() -> "lastModificationTime").int64(this.getLastModificationTime());
        }
    }

    public static interface ReplicationData
    extends Copyable<ReplicationData>,
    Marshallable {
        public static void dropChange(@NotNull ReplicationData replicationData) {
            for (int i = 0; i < 3; ++i) {
                replicationData.setDirtyWordAt(i, 0L);
            }
        }

        public static void raiseChange(@NotNull ReplicationData replicationData) {
            for (int i = 0; i < 3; ++i) {
                replicationData.setDirtyWordAt(i, -1L);
            }
        }

        public static void clearChange(@NotNull ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            replicationData.setDirtyWordAt(index, replicationData.getDirtyWordAt(index) ^ bit);
        }

        public static void setChange(@NotNull ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            replicationData.setDirtyWordAt(index, replicationData.getDirtyWordAt(index) | bit);
        }

        public static boolean isChanged(@NotNull ReplicationData replicationData, int identifier) {
            int index = identifier / 64;
            long bit = 1L << identifier % 64;
            return (replicationData.getDirtyWordAt(index) & bit) != 0L;
        }

        public boolean getDeleted();

        public void setDeleted(boolean var1);

        public long getTimestamp();

        public void setTimestamp(long var1);

        public byte getIdentifier();

        public void setIdentifier(byte var1);

        public long getDirtyWordAt(@MaxSize(value=3) int var1);

        public void setDirtyWordAt(@MaxSize(value=3) int var1, long var2);

        default public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
            this.setDeleted(wire.read(() -> "deleted").bool());
            this.setTimestamp(wire.read(() -> "timestamp").int64());
            this.setIdentifier(wire.read(() -> "identifier").int8());
            for (int i = 0; i < 3; ++i) {
                int finalI = i;
                this.setDirtyWordAt(i, wire.read(() -> "dirtyWord-" + finalI).int64());
            }
        }

        default public void writeMarshallable(@NotNull WireOut wire) {
            wire.write(() -> "deleted").bool(Boolean.valueOf(this.getDeleted()));
            wire.write(() -> "timestamp").int64(this.getTimestamp());
            wire.write(() -> "identifier").int8(this.getIdentifier());
            for (int i = 0; i < 3; ++i) {
                int finalI = i;
                wire.write(() -> "dirtyWord-" + finalI).int64(this.getDirtyWordAt(i));
            }
        }
    }

    public static interface SegmentForKey<Store> {
        public int segmentForKey(Store var1, BytesStore var2);
    }

    public static interface GetValue<Store> {
        @NotNull
        public BytesStore getValue(Store var1, BytesStore var2);
    }

    public static interface ChangeApplier<Store> {
        public void applyChange(Store var1, EngineReplication.ReplicationEntry var2);
    }
}

