/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapEventListener;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemovedEvent<K, V>
implements MapEvent<K, V> {
    private String assetName;
    @Nullable
    private K key;
    @Nullable
    private V oldValue;
    private boolean isReplicationEvent;

    private RemovedEvent(String assetName, @NotNull K key, @Nullable V oldValue, boolean isReplicationEvent) {
        this.assetName = assetName;
        this.key = key;
        this.oldValue = oldValue;
        this.isReplicationEvent = isReplicationEvent;
    }

    @NotNull
    public static <K, V> RemovedEvent<K, V> of(String assetName, K key, V value, boolean isReplicationEvent) {
        return new RemovedEvent<K, V>(assetName, key, value, isReplicationEvent);
    }

    @Override
    public String assetName() {
        return this.assetName;
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull Function<K, K2> keyFunction, @NotNull Function<V, V2> valueFunction) {
        return new RemovedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key), valueFunction.apply(this.oldValue), this.isReplicationEvent);
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull BiFunction<K, K2, K2> keyFunction, @NotNull BiFunction<V, V2, V2> valueFunction) {
        return new RemovedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key, null), valueFunction.apply(this.oldValue, null), this.isReplicationEvent);
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V oldValue() {
        return this.oldValue;
    }

    @Override
    @Nullable
    public V getValue() {
        return null;
    }

    @Override
    public void apply(@NotNull MapEventListener<K, V> listener) {
        listener.remove(this.assetName, this.key, this.oldValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash("removed", this.key, this.oldValue);
    }

    @Override
    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof RemovedEvent).map(o -> (RemovedEvent)o).filter(e -> Objects.equals(this.assetName, e.assetName)).filter(e -> BytesUtil.equals(this.key, e.key)).filter(e -> BytesUtil.equals(this.oldValue, e.oldValue)).filter(e -> BytesUtil.equals((Object)this.isReplicationEvent, (Object)e.isReplicationEvent)).isPresent();
    }

    @NotNull
    public String toString() {
        return "RemovedEvent{assetName='" + this.assetName + '\'' + ", key=" + this.key + ", oldValue=" + this.oldValue + ", isReplicationEvent=" + this.isReplicationEvent + '}';
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read((WireKey)MapEvent.MapEventFields.assetName).text((Object)this, (o, s) -> {
            this.assetName = s;
        });
        wire.read((WireKey)MapEvent.MapEventFields.key).object(Object.class, (Object)this, (o, x) -> {
            o.key = x;
        });
        wire.read((WireKey)MapEvent.MapEventFields.oldValue).object(Object.class, (Object)this, (o, x) -> {
            o.oldValue = x;
        });
        wire.read((WireKey)MapEvent.MapEventFields.isReplicationEvent).bool((Object)this, (o, x) -> {
            o.isReplicationEvent = x;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MapEvent.MapEventFields.assetName).text((CharSequence)this.assetName);
        wire.write((WireKey)MapEvent.MapEventFields.key).object(this.key);
        wire.write((WireKey)MapEvent.MapEventFields.oldValue).object(this.oldValue);
        wire.write((WireKey)MapEvent.MapEventFields.isReplicationEvent).object((Object)this.isReplicationEvent);
    }
}

