/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Iterator;
import java.util.Map;
import java.util.function.BiFunction;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.Assetted;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.Buffers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectObjectKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    @NotNull
    private final BiFunction<K, Bytes, Bytes> keyToBytes;
    @NotNull
    private final BiFunction<V, Bytes, Bytes> valueToBytes;
    @NotNull
    private final BiFunction<BytesStore, K, K> bytesToKey;
    @NotNull
    private final BiFunction<BytesStore, V, V> bytesToValue;
    private final KeyValueStore<BytesStore, BytesStore> kvStore;
    private final Asset asset;

    public ObjectObjectKeyValueStore(@NotNull RequestContext context, Asset asset, Assetted assetted) {
        this.asset = asset;
        Class type = context.type();
        this.keyToBytes = ObjectObjectKeyValueStore.toBytes(type);
        this.bytesToKey = this.fromBytes(type);
        Class type2 = context.type2();
        this.valueToBytes = ObjectObjectKeyValueStore.toBytes(type2);
        this.bytesToValue = this.fromBytes(type2);
        this.kvStore = (KeyValueStore)assetted;
    }

    private static <T> BiFunction<T, Bytes, Bytes> toBytes(Class type) {
        if (type == String.class) {
            return (t, bytes) -> (Bytes)bytes.appendUtf8((CharSequence)((String)t));
        }
        throw new UnsupportedOperationException("todo");
    }

    private <T> BiFunction<BytesStore, T, T> fromBytes(Class type) {
        if (type == String.class) {
            return (t, bytes) -> bytes == null ? null : bytes.toString();
        }
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean put(K key, V value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        Bytes valueBytes = this.valueToBytes.apply(value, b.valueBuffer);
        return this.kvStore.put((BytesStore)keyBytes, (BytesStore)valueBytes);
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        Bytes valueBytes;
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getAndPut((BytesStore)keyBytes, (BytesStore)(valueBytes = this.valueToBytes.apply(value, b.valueBuffer)));
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, null);
    }

    @Override
    public boolean remove(K key) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        return this.kvStore.remove((BytesStore)keyBytes);
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getAndRemove((BytesStore)keyBytes);
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, null);
    }

    @Override
    @Nullable
    public V getUsing(K key, Object value) {
        Buffers b = Buffers.BUFFERS.get();
        Bytes keyBytes = this.keyToBytes.apply(key, b.keyBuffer);
        BytesStore retBytes = this.kvStore.getUsing((BytesStore)keyBytes, b.valueBuffer);
        return retBytes == null ? null : (V)this.bytesToValue.apply(retBytes, value);
    }

    @Override
    public long longSize() {
        return this.kvStore.longSize();
    }

    @Override
    public void keysFor(int segment, @NotNull SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        this.kvStore.keysFor(segment, k -> kConsumer.accept(this.bytesToKey.apply((BytesStore)k, (K)null)));
    }

    @Override
    public void entriesFor(int segment, @NotNull SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        this.kvStore.entriesFor(segment, e -> kvConsumer.accept(e.translate(this.bytesToKey, this.bytesToValue)));
    }

    @Override
    @NotNull
    public Iterator<Map.Entry<K, V>> entrySetIterator() {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public void clear() {
        this.kvStore.clear();
    }

    @Override
    @NotNull
    public V replace(K key, V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public boolean containsValue(V value) {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public Asset asset() {
        return this.asset;
    }

    @Override
    public KeyValueStore underlying() {
        return this.kvStore;
    }

    public void close() {
        this.kvStore.close();
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException("todo");
    }
}

