/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.MapEventListener;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InsertedEvent<K, V>
implements MapEvent<K, V> {
    private boolean isReplicationEvent;
    private String assetName;
    @NotNull
    private K key;
    @Nullable
    private V value;

    private InsertedEvent(String assetName, @NotNull K key, @Nullable V value, boolean isReplicationEvent) {
        this.assetName = assetName;
        this.key = key;
        this.value = value;
        this.isReplicationEvent = isReplicationEvent;
    }

    @NotNull
    public static <K, V> InsertedEvent<K, V> of(String assetName, K key, V value, boolean isReplicationEvent) {
        return new InsertedEvent<K, V>(assetName, key, value, isReplicationEvent);
    }

    @Override
    public String assetName() {
        return this.assetName;
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull Function<K, K2> keyFunction, @NotNull Function<V, V2> valueFunction) {
        return new InsertedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key), valueFunction.apply(this.value), this.isReplicationEvent);
    }

    @Override
    @NotNull
    public <K2, V2> MapEvent<K2, V2> translate(@NotNull BiFunction<K, K2, K2> keyFunction, @NotNull BiFunction<V, V2, V2> valueFunction) {
        return new InsertedEvent<K2, V2>(this.assetName, keyFunction.apply(this.key, null), valueFunction.apply(this.value, null), this.isReplicationEvent);
    }

    @Override
    @Nullable
    public K getKey() {
        return this.key;
    }

    @Override
    @Nullable
    public V oldValue() {
        return null;
    }

    @Override
    @Nullable
    public V getValue() {
        return this.value;
    }

    @Override
    public void apply(@NotNull MapEventListener<K, V> listener) {
        listener.insert(this.assetName, this.key, this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash("inserted", this.key, this.value);
    }

    @Override
    public V setValue(V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean equals(Object obj) {
        return Optional.ofNullable(obj).filter(o -> o instanceof InsertedEvent).map(o -> (InsertedEvent)o).filter(e -> Objects.equals(this.assetName, e.assetName)).filter(e -> BytesUtil.equals(this.key, e.key)).filter(e -> BytesUtil.equals(this.value, e.value)).filter(e -> BytesUtil.equals((Object)this.isReplicationEvent, (Object)e.isReplicationEvent)).isPresent();
    }

    @NotNull
    public String toString() {
        return "InsertedEvent{assetName='" + this.assetName + '\'' + ", key=" + this.key + ", value=" + this.value + ", isReplicationEvent=" + this.isReplicationEvent + '}';
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read((WireKey)MapEvent.MapEventFields.assetName).text((Object)this, (o, s) -> {
            this.assetName = s;
        });
        wire.read((WireKey)MapEvent.MapEventFields.key).object(Object.class, (Object)this, (o, x) -> {
            o.key = x;
        });
        wire.read((WireKey)MapEvent.MapEventFields.value).object(Object.class, (Object)this, (o, x) -> {
            o.value = x;
        });
        wire.read((WireKey)MapEvent.MapEventFields.isReplicationEvent).bool((Object)this, (o, x) -> {
            o.isReplicationEvent = x;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MapEvent.MapEventFields.assetName).text((CharSequence)this.assetName);
        wire.write((WireKey)MapEvent.MapEventFields.key).object(this.key);
        wire.write((WireKey)MapEvent.MapEventFields.value).object(this.value);
        wire.write((WireKey)MapEvent.MapEventFields.isReplicationEvent).bool(Boolean.valueOf(this.isReplicationEvent));
    }
}

