/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.pubsub.InvalidSubscriberException;
import net.openhft.chronicle.engine.api.pubsub.SubscriptionConsumer;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.map.FilePerKeyValueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FilePerKeyValueStoreBackedKeyValueStore<K, V>
implements KeyValueStore<K, V> {
    private final FilePerKeyValueStore filePerKeyValueStore;
    private final Function<K, String> keyToString;
    private final Function<V, BytesStore> valueToBytesStore;
    private final Function<BytesStore, V> bytesStoreToValue;

    public FilePerKeyValueStoreBackedKeyValueStore(FilePerKeyValueStore filePerKeyValueStore, Function<K, String> keyToString, Function<V, BytesStore> valueToBytesStore, Function<BytesStore, V> bytesStoreToValue) {
        this.filePerKeyValueStore = filePerKeyValueStore;
        this.keyToString = keyToString;
        this.valueToBytesStore = valueToBytesStore;
        this.bytesStoreToValue = bytesStoreToValue;
    }

    @Nullable
    private V nullableToValue(@Nullable BytesStore outputValue) {
        return outputValue != null ? (V)this.bytesStoreToValue.apply(outputValue) : null;
    }

    @Override
    public boolean put(K key, V value) {
        BytesStore inputValue = this.valueToBytesStore.apply(value);
        return this.filePerKeyValueStore.put(this.keyToString.apply(key), inputValue);
    }

    @Override
    @Nullable
    public V getAndPut(K key, V value) {
        BytesStore inputValue = this.valueToBytesStore.apply(value);
        BytesStore outputValue = this.filePerKeyValueStore.getAndPut(this.keyToString.apply(key), inputValue);
        return this.nullableToValue(outputValue);
    }

    @Override
    public boolean remove(K key) {
        return this.filePerKeyValueStore.remove(this.keyToString.apply(key));
    }

    @Override
    @Nullable
    public V getAndRemove(K key) {
        return this.nullableToValue(this.filePerKeyValueStore.getAndRemove(this.keyToString.apply(key)));
    }

    @Override
    @Nullable
    public V getUsing(K key, Object value) {
        return this.nullableToValue((BytesStore)this.filePerKeyValueStore.get(this.keyToString.apply(key)));
    }

    @Override
    public long longSize() {
        return this.filePerKeyValueStore.longSize();
    }

    @Override
    public void keysFor(int segment, SubscriptionConsumer<K> kConsumer) throws InvalidSubscriberException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void entriesFor(int segment, SubscriptionConsumer<MapEvent<K, V>> kvConsumer) throws InvalidSubscriberException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.filePerKeyValueStore.clear();
    }

    @Override
    public boolean containsValue(V value) {
        return this.filePerKeyValueStore.containsValue(this.valueToBytesStore.apply(value));
    }

    @Override
    @NotNull
    public Asset asset() {
        return this.filePerKeyValueStore.asset();
    }

    @Override
    @Nullable
    public KeyValueStore<K, V> underlying() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        this.filePerKeyValueStore.close();
    }

    @Override
    public void accept(EngineReplication.ReplicationEntry replicationEntry) {
        throw new UnsupportedOperationException();
    }
}

