/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.map;

import java.util.function.Consumer;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.PointerBytesStore;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.EngineReplication;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.map.replication.Bootstrap;
import net.openhft.chronicle.hash.replication.EngineReplicationLangBytesConsumer;
import net.openhft.chronicle.map.EngineReplicationLangBytes;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.lang.io.Bytes;
import net.openhft.lang.io.NativeBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CMap2EngineReplicator
implements EngineReplication,
EngineReplicationLangBytesConsumer {
    private static final Logger LOG = LoggerFactory.getLogger(CMap2EngineReplicator.class);
    final ThreadLocal<KvBytes> kvBytesThreadLocal = ThreadLocal.withInitial(() -> new KvBytes());
    private final RequestContext context;
    private final ThreadLocal<PointerBytesStore> keyLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private final ThreadLocal<PointerBytesStore> valueLocal = ThreadLocal.withInitial(PointerBytesStore::new);
    private final ThreadLocal<KvLangBytes> kvByte = ThreadLocal.withInitial(KvLangBytes::new);
    private EngineReplicationLangBytes engineReplicationLang;

    public CMap2EngineReplicator(RequestContext requestContext, @NotNull Asset asset) {
        this(requestContext);
        asset.addView(EngineReplicationLangBytesConsumer.class, this);
    }

    public CMap2EngineReplicator(RequestContext context) {
        this.context = context;
    }

    public void set(@NotNull EngineReplicationLangBytes engineReplicationLangBytes) {
        this.engineReplicationLang = engineReplicationLangBytes;
    }

    @NotNull
    private Bytes toLangBytes(@NotNull BytesStore b, @NotNull net.openhft.chronicle.bytes.Bytes tmpBytes, @NotNull NativeBytes lb) {
        if (b.isNative()) {
            lb.setStartPositionAddress(b.address(b.start()), b.address(b.readLimit()));
        } else {
            tmpBytes.clear();
            tmpBytes.write(b);
            lb.setStartPositionAddress(tmpBytes.address(tmpBytes.start()), tmpBytes.address(tmpBytes.readLimit()));
        }
        return lb;
    }

    private void check(@NotNull BytesStore b) {
        for (long i = b.start(); i < b.readLimit(); ++i) {
            byte ch = b.readByte(i);
            if (ch < 32) {
                throw new AssertionError((Object)("Char " + ch));
            }
        }
    }

    private void check(@NotNull Bytes b) {
        byte ch;
        long i;
        if (b.position() != 0L) {
            throw new AssertionError();
        }
        if (b.remaining() != b.limit()) {
            throw new AssertionError();
        }
        for (i = 0L; i < 16L && i < b.limit(); ++i) {
            ch = b.readByte(i);
            if (ch < 32) {
                throw new AssertionError((Object)("Char " + ch));
            }
        }
        if (b.limit() > 32L) {
            for (i = b.limit() - 16L; i < b.limit(); ++i) {
                ch = b.readByte(i);
                if (ch < 32) {
                    throw new AssertionError((Object)("Char " + ch));
                }
            }
        }
    }

    public void put(@NotNull BytesStore key, @NotNull BytesStore value, byte remoteIdentifier, long timestamp) {
        KvLangBytes kv = this.kvByte.get();
        Bytes keyBytes = this.toLangBytes(key, kv.tmpKeyBytes, kv.key);
        Bytes valueBytes = this.toLangBytes(value, kv.tmpValueBytes, kv.value);
        this.engineReplicationLang.put(keyBytes, valueBytes, remoteIdentifier, timestamp);
        keyBytes.position(0L);
        valueBytes.position(0L);
    }

    private void remove(@NotNull BytesStore key, byte remoteIdentifier, long timestamp) {
        KvLangBytes kv = this.kvByte.get();
        Bytes keyBytes = this.toLangBytes(key, kv.tmpKeyBytes, kv.key);
        this.engineReplicationLang.remove(keyBytes, remoteIdentifier, timestamp);
    }

    @Override
    public byte identifier() {
        return this.engineReplicationLang.identifier();
    }

    private void put(@NotNull EngineReplication.ReplicationEntry entry) {
        this.put(entry.key(), entry.value(), entry.identifier(), entry.timestamp());
    }

    private void remove(@NotNull EngineReplication.ReplicationEntry entry) {
        this.remove(entry.key(), entry.identifier(), entry.timestamp());
    }

    @Override
    public void applyReplication(@NotNull EngineReplication.ReplicationEntry entry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("applyReplication entry=" + entry);
        }
        if (entry.isDeleted()) {
            this.remove(entry);
        } else {
            this.put(entry);
        }
    }

    @Override
    @Nullable
    public EngineReplication.ModificationIterator acquireModificationIterator(final byte remoteIdentifier) {
        final EngineReplicationLangBytes.EngineModificationIterator instance = this.engineReplicationLang.acquireEngineModificationIterator(remoteIdentifier);
        return new EngineReplication.ModificationIterator(){

            @Override
            public boolean hasNext() {
                return instance.hasNext();
            }

            @Override
            public boolean nextEntry(@NotNull Consumer<EngineReplication.ReplicationEntry> consumer) {
                return this.nextEntry((EngineReplication.ReplicationEntry entry) -> {
                    consumer.accept(entry);
                    return true;
                });
            }

            boolean nextEntry(@NotNull EngineReplication.EntryCallback callback) {
                return instance.nextEntry((key, value, timestamp, identifier, isDeleted, bootStrapTimeStamp) -> {
                    KvBytes threadLocal = CMap2EngineReplicator.this.kvBytesThreadLocal.get();
                    VanillaReplicatedEntry entry = new VanillaReplicatedEntry((BytesStore)this.toKey(key, threadLocal.key(key.remaining())), this.toValue(value, threadLocal.value(value.remaining())), timestamp, identifier, isDeleted, bootStrapTimeStamp, remoteIdentifier);
                    return callback.onEntry(entry);
                });
            }

            private PointerBytesStore toKey(@NotNull Bytes key, PointerBytesStore pbs) {
                pbs.set(key.address(), key.capacity());
                return pbs;
            }

            @Nullable
            private BytesStore toValue(@Nullable Bytes value, PointerBytesStore pbs) {
                if (value == null) {
                    return null;
                }
                pbs.set(value.address(), value.capacity());
                return pbs;
            }

            @Override
            public void dirtyEntries(long fromTimeStamp) {
                instance.dirtyEntries(fromTimeStamp);
            }

            @Override
            public void setModificationNotifier(@NotNull EngineReplication.ModificationNotifier modificationNotifier) {
                instance.setModificationNotifier(modificationNotifier::onChange);
            }
        };
    }

    @Override
    public long lastModificationTime(byte remoteIdentifier) {
        return this.engineReplicationLang.lastModificationTime(remoteIdentifier);
    }

    @Override
    public void setLastModificationTime(byte identifier, long timestamp) {
        this.engineReplicationLang.setLastModificationTime(identifier, timestamp);
    }

    @NotNull
    public String toString() {
        return "CMap2EngineReplicator{context=" + this.context + ", identifier=" + this.engineReplicationLang.identifier() + ", keyLocal=" + this.keyLocal + ", valueLocal=" + this.valueLocal + '}';
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{VanillaReplicatedEntry.class});
        ClassAliasPool.CLASS_ALIASES.addAlias(new Class[]{Bootstrap.class});
    }

    public static class VanillaReplicatedEntry
    implements EngineReplication.ReplicationEntry {
        private final byte remoteIdentifier;
        private BytesStore key;
        @Nullable
        private BytesStore value;
        private long timestamp;
        private byte identifier;
        private boolean isDeleted;
        private long bootStrapTimeStamp;

        VanillaReplicatedEntry(@NotNull BytesStore key, @Nullable BytesStore value, long timestamp, byte identifier, boolean isDeleted, long bootStrapTimeStamp, byte remoteIdentifier) {
            this.key = key;
            this.remoteIdentifier = remoteIdentifier;
            assert (key.underlyingObject() == null);
            this.value = value;
            assert (value == null || value.underlyingObject() == null);
            this.timestamp = timestamp;
            this.identifier = identifier;
            this.isDeleted = isDeleted;
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }

        public VanillaReplicatedEntry() {
            this.remoteIdentifier = 0;
            this.key = BytesStore.nativePointer();
            this.value = BytesStore.nativePointer();
        }

        @Override
        public void readMarshallable(@NotNull WireIn wire) {
            wire.read(() -> "key").bytesSet((PointerBytesStore)this.key);
            wire.read(() -> "value").bytesSet((PointerBytesStore)this.value);
            this.timestamp(wire.read(() -> "timestamp").int64());
            this.identifier(wire.read(() -> "identifier").int8());
            this.isDeleted(wire.read(() -> "isDeleted").bool());
            this.bootStrapTimeStamp(wire.read(() -> "bootStrapTimeStamp").int64());
        }

        @Override
        public BytesStore key() {
            return this.key;
        }

        @Override
        @Nullable
        public BytesStore value() {
            return this.value != null && this.value.isPresent() ? this.value : null;
        }

        @Override
        public long timestamp() {
            return this.timestamp;
        }

        @Override
        public byte identifier() {
            return this.identifier;
        }

        @Override
        public byte remoteIdentifier() {
            return this.remoteIdentifier;
        }

        @Override
        public boolean isDeleted() {
            return this.isDeleted;
        }

        @Override
        public long bootStrapTimeStamp() {
            return this.bootStrapTimeStamp;
        }

        @Override
        public void key(BytesStore key) {
            this.key = key;
        }

        @Override
        public void value(BytesStore value) {
            this.value = value;
        }

        @Override
        public void timestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        @Override
        public void identifier(byte identifier) {
            this.identifier = identifier;
        }

        @Override
        public void isDeleted(boolean isDeleted) {
            this.isDeleted = isDeleted;
        }

        @Override
        public void bootStrapTimeStamp(long bootStrapTimeStamp) {
            this.bootStrapTimeStamp = bootStrapTimeStamp;
        }

        @NotNull
        public String toString() {
            net.openhft.chronicle.bytes.Bytes bytes = net.openhft.chronicle.bytes.Bytes.elasticByteBuffer();
            new TextWire(bytes).writeDocument(false, d -> d.write().typedMarshallable((WriteMarshallable)this));
            return "\n" + Wires.fromSizePrefixedBlobs((net.openhft.chronicle.bytes.Bytes)bytes);
        }
    }

    private static class KvBytes {
        private final PointerBytesStore key = BytesStore.nativePointer();
        private final PointerBytesStore value = BytesStore.nativePointer();

        private KvBytes() {
        }

        private PointerBytesStore key(long size) {
            return this.key;
        }

        private PointerBytesStore value(long size) {
            return this.value;
        }
    }

    static class KvLangBytes {
        final NativeBytes key = NativeBytes.empty();
        final NativeBytes value = NativeBytes.empty();
        final net.openhft.chronicle.bytes.Bytes tmpKeyBytes = net.openhft.chronicle.bytes.Bytes.allocateElasticDirect();
        final net.openhft.chronicle.bytes.Bytes tmpValueBytes = net.openhft.chronicle.bytes.Bytes.allocateElasticDirect();

        KvLangBytes() {
        }
    }
}

