/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.threads.HandlerPriority;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HostDetails
implements Marshallable,
Closeable {
    private final Map<InetSocketAddress, TcpChannelHub> tcpChannelHubs = new ConcurrentHashMap<InetSocketAddress, TcpChannelHub>();
    public int hostId;
    public int tcpBufferSize;
    public String connectUri;
    public int timeoutMs;

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "hostId").int32((Object)this, (o, i) -> {
            o.hostId = i;
        }).read(() -> "tcpBufferSize").int32((Object)this, (o, i) -> {
            o.tcpBufferSize = i;
        }).read(() -> "connectUri").text((Object)this, (o, i) -> {
            o.connectUri = i;
        }).read(() -> "timeoutMs").int32((Object)this, (o, i) -> {
            o.timeoutMs = i;
        });
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write(() -> "hostId").int32(this.hostId).write(() -> "tcpBufferSize").int32(this.tcpBufferSize).write(() -> "connectUri").text((CharSequence)this.connectUri).write(() -> "timeoutMs").int32(this.timeoutMs);
    }

    public HostDetails() {
    }

    public HostDetails(int hostId, int tcpBufferSize, String connectUri, int timeoutMs) {
        this.hostId = hostId;
        this.tcpBufferSize = tcpBufferSize;
        this.connectUri = connectUri;
        this.timeoutMs = timeoutMs;
    }

    public TcpChannelHub acquireTcpChannelHub(@NotNull Asset asset, @NotNull EventLoop eventLoop, @NotNull Function<Bytes, Wire> wire) {
        SessionDetails sessionDetails = asset.root().findView(SessionDetails.class);
        InetSocketAddress addr = TCPRegistry.lookup((String)this.connectUri);
        return this.tcpChannelHubs.computeIfAbsent(addr, hostPort -> {
            String[] connectURIs = new String[]{this.connectUri};
            SocketAddressSupplier socketAddressSupplier = new SocketAddressSupplier(connectURIs, "hostId=" + this.hostId + ",connectUri=" + this.connectUri);
            ClientConnectionMonitor clientConnectionMonitor = asset.findView(ClientConnectionMonitor.class);
            return new TcpChannelHub((SessionProvider)new SimpleSessionProvider(sessionDetails), eventLoop, wire, "hostId=" + this.hostId + ",connectUri=" + this.connectUri, socketAddressSupplier, true, clientConnectionMonitor, HandlerPriority.TIMER);
        });
    }

    public TcpChannelHub tcpChannelHub() {
        return this.tcpChannelHubs.get(TCPRegistry.lookup((String)this.connectUri));
    }

    public void close() {
        this.tcpChannelHubs.values().forEach(Closeable::closeQuietly);
    }

    @NotNull
    public String toString() {
        return "HostDetails{hostId=" + this.hostId + ", connectUri='" + this.connectUri + '}';
    }

    private class SimpleSessionProvider
    implements SessionProvider {
        private final SessionDetails sessionDetails;

        public SimpleSessionProvider(SessionDetails sessionDetails) {
            this.sessionDetails = sessionDetails == null ? VanillaSessionDetails.of((String)"", (String)"", (String)"") : sessionDetails;
        }

        @Nullable
        public SessionDetails get() {
            return this.sessionDetails;
        }

        public void set(@NotNull SessionDetails sessionDetails) {
            throw new UnsupportedOperationException();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

