/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.fs;

import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.fs.MountPoint;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class Fstab
implements Marshallable {
    @NotNull
    private final Map<String, MountPoint> mounts = new ConcurrentSkipListMap<String, MountPoint>();

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        StringBuilder mountDesc = new StringBuilder();
        while (wire.hasMore()) {
            MountPoint mp = (MountPoint)wire.readEventName(mountDesc).typedMarshallable();
            this.mounts.put(mountDesc.toString(), mp);
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        for (Map.Entry<String, MountPoint> entry : this.mounts.entrySet()) {
            wire.writeEventName(entry::getKey).typedMarshallable((WriteMarshallable)entry.getValue());
        }
    }

    public void install(String baseDir, AssetTree assetTree) {
        this.mounts.values().forEach(mp -> mp.install(baseDir, assetTree));
    }
}

