/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.util.Collection;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.wire.ParameterizeWireKey;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.ValueOut;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionWireHandler<U, C extends Collection<U>> {
    private static final int SIZE_OF_SIZE = 4;
    private static final Logger LOG = LoggerFactory.getLogger(CollectionWireHandler.class);
    private Function<ValueIn, U> fromWire;
    private BiConsumer<ValueOut, U> toWire;
    @Nullable
    private WireIn inWire = null;
    @Nullable
    private WireOut outWire = null;
    private C underlyingCollection;
    private long tid;
    private Supplier<C> factory;
    private final ReadMarshallable dataConsumer = new ReadMarshallable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void readMarshallable(WireIn wire) throws IllegalStateException {
            Bytes outBytes = CollectionWireHandler.this.outWire.bytes();
            try {
                StringBuilder eventName = Wires.acquireStringBuilder();
                ValueIn valueIn = CollectionWireHandler.this.inWire.readEventName(eventName);
                CollectionWireHandler.this.outWire.writeDocument(true, w -> w.writeEventName((WireKey)CoreFields.tid).int64(CollectionWireHandler.this.tid));
                CollectionWireHandler.this.outWire.writeDocument(false, out -> {
                    if (EventId.remove.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.remove(CollectionWireHandler.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (EventId.iterator.contentEquals(eventName)) {
                        ValueOut valueOut = out.writeEventName((WireKey)CoreFields.reply);
                        valueOut.sequence(v -> CollectionWireHandler.this.underlyingCollection.forEach(e -> CollectionWireHandler.this.toWire.accept(v, e)));
                        return;
                    }
                    if (EventId.numberOfSegments.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).int32(1);
                        return;
                    }
                    if (EventId.isEmpty.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.isEmpty()));
                        return;
                    }
                    if (EventId.size.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).int32(CollectionWireHandler.this.underlyingCollection.size());
                        return;
                    }
                    if (EventId.clear.contentEquals(eventName)) {
                        CollectionWireHandler.this.underlyingCollection.clear();
                        return;
                    }
                    if (EventId.contains.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.contains(CollectionWireHandler.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (EventId.add.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.add(CollectionWireHandler.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (EventId.remove.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.remove(CollectionWireHandler.this.fromWire.apply(valueIn))));
                        return;
                    }
                    if (EventId.containsAll.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.remove(CollectionWireHandler.this.collectionFromWire())));
                        return;
                    }
                    if (EventId.addAll.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.addAll(CollectionWireHandler.this.collectionFromWire())));
                        return;
                    }
                    if (EventId.removeAll.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.removeAll(CollectionWireHandler.this.collectionFromWire())));
                        return;
                    }
                    if (EventId.retainAll.contentEquals(eventName)) {
                        CollectionWireHandler.this.outWire.write((WireKey)CoreFields.reply).bool(Boolean.valueOf(CollectionWireHandler.this.underlyingCollection.retainAll(CollectionWireHandler.this.collectionFromWire())));
                        return;
                    }
                    throw new IllegalStateException("unsupported event=" + eventName);
                });
            }
            catch (Exception e) {
                LOG.error("", (Throwable)e);
            }
            finally {
                long len;
                if (YamlLogging.showServerWrites && (len = outBytes.writePosition()) >= 4L) {
                    String s = Wires.fromSizePrefixedBlobs((Bytes)outBytes);
                    LOG.info("server writes:\n\n" + s);
                }
            }
        }
    };

    private C collectionFromWire() {
        Collection c = (Collection)this.factory.get();
        ValueIn valueIn = ((Wire)this.outWire).getValueIn();
        while (valueIn.hasNextSequenceItem()) {
            c.add(this.fromWire.apply(valueIn));
        }
        return (C)c;
    }

    public void process(@NotNull WireIn in, @NotNull WireOut out, @NotNull C collection, @NotNull BiConsumer toWire, @NotNull Function fromWire, @NotNull Supplier factory, long tid) {
        this.fromWire = fromWire;
        this.toWire = toWire;
        this.underlyingCollection = collection;
        this.factory = factory;
        try {
            this.inWire = in;
            this.outWire = out;
            this.tid = tid;
            this.dataConsumer.readMarshallable(in);
        }
        catch (Exception e) {
            LOG.error("", (Throwable)e);
        }
    }

    static enum EventId implements ParameterizeWireKey
    {
        size(new WireKey[0]),
        isEmpty(new WireKey[0]),
        add(new WireKey[0]),
        addAll(new WireKey[0]),
        retainAll(new WireKey[0]),
        containsAll(new WireKey[0]),
        removeAll(new WireKey[0]),
        clear(new WireKey[0]),
        remove((WireKey[])new Params[]{Params.key}),
        numberOfSegments(new WireKey[0]),
        contains((WireKey[])new Params[]{Params.key}),
        identifier(new WireKey[0]),
        iterator((WireKey[])new Params[]{Params.segment});

        private final WireKey[] params;

        private <P extends WireKey> EventId(P ... params) {
            this.params = params;
        }

        @NotNull
        public <P extends WireKey> P[] params() {
            return this.params;
        }
    }

    static enum Params implements WireKey
    {
        key,
        segment;

    }
}

