/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.collection;

import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.engine.collection.CollectionWireHandler;
import net.openhft.chronicle.network.connection.AbstractStatelessClient;
import net.openhft.chronicle.network.connection.CoreFields;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireKey;
import org.jetbrains.annotations.NotNull;

public class ClientWiredStatelessChronicleCollection<U, E extends Collection<U>>
extends AbstractStatelessClient<CollectionWireHandler.EventId>
implements Collection<U> {
    @NotNull
    private final Function<ValueIn, U> consumer;
    @NotNull
    private final Supplier<E> factory;

    public ClientWiredStatelessChronicleCollection(@NotNull TcpChannelHub hub, @NotNull Supplier<E> factory, @NotNull Function<ValueIn, U> wireToSet, @NotNull String csp, long cid) {
        super(hub, cid, csp);
        this.consumer = wireToSet;
        this.factory = factory;
    }

    @Override
    public int size() {
        return this.proxyReturnInt((WireKey)CollectionWireHandler.EventId.size);
    }

    @Override
    public boolean isEmpty() {
        return this.proxyReturnBoolean((WireKey)CollectionWireHandler.EventId.isEmpty);
    }

    @Override
    public boolean contains(Object o) {
        return this.proxyReturnBooleanWithArgs(CollectionWireHandler.EventId.contains, new Object[]{o});
    }

    @Override
    @NotNull
    public Iterator<U> iterator() {
        int numberOfSegments = this.proxyReturnUint16((WireKey)CollectionWireHandler.EventId.numberOfSegments);
        return this.segmentSet(1).iterator();
    }

    @NotNull
    private E segmentSet(int segment) {
        return (E)((Collection)this.proxyReturnWireConsumerInOut((WireKey)CollectionWireHandler.EventId.iterator, (WireKey)CoreFields.reply, valueOut -> valueOut.uint16((long)segment), read -> {
            Collection e = (Collection)this.factory.get();
            read.sequence((Object)e, (e2, s) -> {
                while (read.hasNextSequenceItem()) {
                    e2.add(this.consumer.apply((ValueIn)read));
                }
            });
            return e;
        }));
    }

    @Override
    @NotNull
    public Object[] toArray() {
        return this.asCollection().toArray();
    }

    @NotNull
    private E asCollection() {
        Collection e = (Collection)this.factory.get();
        int numberOfSegments = this.proxyReturnUint16((WireKey)CollectionWireHandler.EventId.numberOfSegments);
        long j = 0L;
        while (j < (long)numberOfSegments) {
            long i = j++;
            this.proxyReturnWireConsumerInOut((WireKey)CollectionWireHandler.EventId.iterator, (WireKey)CoreFields.reply, valueOut -> valueOut.uint16(i), read -> read.sequence((Object)e, (e2, r) -> {
                while (r.hasNextSequenceItem()) {
                    e2.add(this.consumer.apply((ValueIn)r));
                }
            }));
        }
        return (E)e;
    }

    @Override
    @NotNull
    public <T> T[] toArray(@NotNull T[] array) {
        return this.asCollection().toArray(array);
    }

    @Override
    public boolean add(U u) {
        return this.proxyReturnBoolean((WireKey)CollectionWireHandler.EventId.add);
    }

    @Override
    public boolean remove(Object o) {
        return this.proxyReturnBooleanWithArgs(CollectionWireHandler.EventId.remove, new Object[]{o});
    }

    @Override
    public boolean containsAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.EventId.containsAll, c);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends U> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.EventId.addAll, c);
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.EventId.retainAll, c);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        return this.proxyReturnBooleanWithSequence(CollectionWireHandler.EventId.removeAll, c);
    }

    @Override
    public void clear() {
        this.proxyReturnVoid((WireKey)CollectionWireHandler.EventId.clear);
    }
}

