/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.server.ServerEndpoint;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerCfg
implements Installable,
Marshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerCfg.class);
    private int port;
    private WireType wireType;
    private YamlLogging.YamlLoggingLevel logTCPMessages;
    private ServerEndpoint serverEndpoint;
    private int heartbeatIntervalTicks;
    private int heartbeatIntervalTimeout;

    @Override
    public ServerCfg install(String path, AssetTree assetTree) throws IOException {
        LOGGER.info(path + ": Starting listener on port " + this.port);
        this.serverEndpoint = new ServerEndpoint("*:" + this.port, assetTree, this.wireType, this.heartbeatIntervalTicks, this.heartbeatIntervalTimeout);
        YamlLogging.setAll((boolean)false);
        return this;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "wireType").asEnum(WireType.class, wt -> {
            this.wireType = wt;
        });
        wire.read(() -> "port").int32((Object)this, (o, i) -> {
            o.port = i;
        });
        wire.read(() -> "logTCPMessages").asEnum(YamlLogging.YamlLoggingLevel.class, (Object)this, (o, b) -> {
            o.logTCPMessages = b;
        });
        wire.read(() -> "heartbeatIntervalTicks").int32((Object)this, (o, i) -> {
            o.heartbeatIntervalTicks = i;
        });
        wire.read(() -> "heartbeatIntervalTimeout").int32((Object)this, (o, i) -> {
            o.heartbeatIntervalTimeout = i;
        });
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "wireType").asEnum((Enum)this.wireType);
        wire.write(() -> "port").int32(this.port);
        wire.write(() -> "logTCPMessages").asEnum((Enum)this.logTCPMessages);
        wire.write(() -> "heartbeatIntervalTicks").int32(this.heartbeatIntervalTicks);
        wire.write(() -> "heartbeatIntervalTimeout").int32(this.heartbeatIntervalTimeout);
    }

    public String toString() {
        return "ServerCfg{port=" + this.port + ", wireType=" + this.wireType + ", logTCPMessages=" + this.logTCPMessages + ", serverEndpoint=" + this.serverEndpoint + ", heartbeatIntervalTicks=" + this.heartbeatIntervalTicks + ", heartbeatIntervalTimeout=" + this.heartbeatIntervalTimeout + '}';
    }
}

