/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import java.net.URISyntaxException;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.cfg.SubscriptionStat;
import net.openhft.chronicle.engine.cfg.UserStat;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonitorCfg
implements Installable,
Marshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MonitorCfg.class);
    private boolean subscriptionMonitoringEnabled;
    private boolean userMonitoringEnabled;

    @Override
    public MonitorCfg install(String path, AssetTree assetTree) throws IOException, URISyntaxException {
        if (this.subscriptionMonitoringEnabled) {
            LOGGER.info("Enabling Subscription Monitoring for " + assetTree);
            assetTree.acquireMap("/proc/subscriptions", String.class, SubscriptionStat.class);
        }
        if (this.userMonitoringEnabled) {
            LOGGER.info("Enabling User Monitoring for " + assetTree);
            assetTree.acquireMap("/proc/users", String.class, UserStat.class);
        }
        return this;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "subscriptionMonitoringEnabled").bool((Object)this, (o, b) -> {
            o.subscriptionMonitoringEnabled = b;
        }).read(() -> "userMonitoringEnabled").bool((Object)this, (o, b) -> {
            o.userMonitoringEnabled = b;
        });
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "subscriptionMonitoringEnabled").bool(Boolean.valueOf(this.subscriptionMonitoringEnabled)).write(() -> "userMonitoringEnabled").bool(Boolean.valueOf(this.userMonitoringEnabled));
    }

    public String toString() {
        return "MonitorCfg{subscriptionMonitoringEnabled=" + this.subscriptionMonitoringEnabled + "userMonitoringEnabled=" + this.userMonitoringEnabled + '}';
    }
}

