/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.wire.Marshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmxCfg
implements Installable,
Marshallable {
    private static final Logger LOGGER = LoggerFactory.getLogger(JmxCfg.class);
    private boolean enabled;

    @Override
    public JmxCfg install(String path, AssetTree assetTree) {
        if (this.enabled) {
            LOGGER.info("Enabling JMX for " + assetTree);
            assetTree.enableManagement();
        }
        return this;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "enabled").bool((Object)this, (o, b) -> {
            o.enabled = b;
        });
    }

    public void writeMarshallable(WireOut wire) {
        wire.write(() -> "enabled").bool(Boolean.valueOf(this.enabled));
    }

    public String toString() {
        return "JmxCfg{enabled=" + this.enabled + '}';
    }
}

