/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.io.IOException;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.api.tree.RequestContext;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.map.AuthenticatedKeyValueStore;
import net.openhft.chronicle.engine.map.FilePerKeyValueStore;
import net.openhft.chronicle.engine.tree.VanillaAsset;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilePerKeyMapCfg
implements Installable {
    private static final Logger LOGGER = LoggerFactory.getLogger(FilePerKeyMapCfg.class);
    private Class keyType;
    private Class valueType;
    private boolean putReturnsNull;
    private boolean removeReturnsNull;
    private String compression;
    private String diskPath;

    @Override
    public Void install(String path, AssetTree assetTree) throws IOException {
        Asset asset = assetTree.acquireAsset(path);
        ((VanillaAsset)asset).enableTranslatingValuesToBytesStore();
        String uri = path + "?putReturnsNull=" + this.putReturnsNull + "&removeReturnsNull=" + this.removeReturnsNull;
        RequestContext rc = RequestContext.requestContext(uri);
        asset.addView(AuthenticatedKeyValueStore.class, new FilePerKeyValueStore(rc, asset));
        MapView mapView = assetTree.acquireMap(uri, this.keyType, this.valueType);
        LOGGER.info("Added FilePerKeyMap " + path + ", size: " + mapView.size());
        return null;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        wire.read(() -> "keyType").typeLiteral((Object)this, (o, c) -> {
            o.keyType = c;
        }).read(() -> "valueType").typeLiteral((Object)this, (o, c) -> {
            o.valueType = c;
        }).read(() -> "compression").text((Object)this, (o, c) -> {
            o.compression = c;
        }).read(() -> "putReturnsNull").bool((Object)this, (o, e) -> {
            o.putReturnsNull = e;
        }).read(() -> "removeReturnsNull").bool((Object)this, (o, e) -> {
            o.removeReturnsNull = e;
        }).read(() -> "diskPath").text((Object)this, (o, s) -> {
            o.diskPath = s;
        });
    }

    public String toString() {
        return "FilePerKeyMapCfg{keyType=" + this.keyType + ", valueType=" + this.valueType + ", putReturnsNull=" + this.putReturnsNull + ", removeReturnsNull=" + this.removeReturnsNull + ", compression='" + this.compression + '\'' + ", diskPath='" + this.diskPath + '\'' + '}';
    }
}

