/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.cfg;

import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.WireIn;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineCfg
implements Installable {
    static final Logger LOGGER = LoggerFactory.getLogger(EngineCfg.class);
    final Map<String, Installable> installableMap = new LinkedHashMap<String, Installable>();

    @Override
    public Void install(String path, AssetTree assetTree) throws Exception {
        LOGGER.info("Building Engine " + assetTree);
        for (Map.Entry<String, Installable> entry : this.installableMap.entrySet()) {
            String path2 = entry.getKey();
            LOGGER.info("Installing " + path2 + ": " + entry.getValue());
            Object install = entry.getValue().install(path2, assetTree);
            if (install == null) continue;
            int pos = path2.lastIndexOf(47);
            String parent = path2.substring(0, pos);
            MapView<String, Object> map = assetTree.acquireMap(parent, String.class, Object.class);
            String name = path2.substring(pos + 1);
            map.put(name, install);
        }
        return null;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IllegalStateException {
        this.readMarshallable("", wire);
    }

    private void readMarshallable(String path, WireIn wire) {
        StringBuilder name = new StringBuilder();
        while (wire.hasMore()) {
            ValueIn in = wire.read(name);
            long pos = wire.bytes().readPosition();
            String path2 = path + "/" + name;
            if (wire.getValueIn().isTyped()) {
                wire.bytes().readPosition(pos);
                Object o = in.typedMarshallable();
                this.installableMap.put(path2, (Installable)o);
                continue;
            }
            in.marshallable(w -> this.readMarshallable(path2, w));
        }
    }
}

