/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.management.mbean;

import net.openhft.chronicle.engine.api.management.ManagementTools;
import net.openhft.chronicle.engine.api.management.mbean.AssetTreeJMXMBean;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetTreeJMX
implements AssetTreeJMXMBean {
    private static final Logger LOG = LoggerFactory.getLogger(ManagementTools.class);
    private long size;
    private String entries;
    private String keyType;
    private Class keyTypeClass;
    private String valueType;
    private Class valueTypeClass;
    private int topicSubscriberCount;
    private int keySubscriberCount;
    private int entrySubscriberCount;
    private String keyStoreValue;
    private String path;

    public AssetTreeJMX() {
    }

    public AssetTreeJMX(@NotNull ObjectKeyValueStore view, @NotNull ObjectSubscription objectSubscription, String path, String entries) {
        this.size = view.longSize();
        this.entries = entries;
        this.keyTypeClass = view.keyType();
        this.keyType = this.keyTypeClass.getName();
        this.valueTypeClass = view.valueType();
        this.valueType = this.valueTypeClass.getName();
        this.topicSubscriberCount = objectSubscription.topicSubscriberCount();
        this.keySubscriberCount = objectSubscription.keySubscriberCount();
        this.entrySubscriberCount = objectSubscription.entrySubscriberCount();
        this.keyStoreValue = objectSubscription.getClass().getName();
        this.path = path;
    }

    @Override
    public String getEntries() {
        return this.entries;
    }

    @Override
    public long getSize() {
        return this.size;
    }

    @Override
    public void setSize(long size) {
        this.size = size;
    }

    @Override
    public String getKeyType() {
        return this.keyType;
    }

    @Override
    public String getValueType() {
        return this.valueType;
    }

    @Override
    public int getTopicSubscriberCount() {
        return this.topicSubscriberCount;
    }

    @Override
    public int getKeySubscriberCount() {
        return this.keySubscriberCount;
    }

    @Override
    public int getEntrySubscriberCount() {
        return this.entrySubscriberCount;
    }

    @Override
    public String getKeyStoreValue() {
        return this.keyStoreValue;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public void notifyMe(String key, String value) {
        LOG.info("Added Key = " + this.keyTypeClass.cast(key));
        LOG.info("Added Value = " + this.valueTypeClass.cast(value));
        LOG.info("changed size: " + this.size);
    }
}

