/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine.api.management;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.rmi.registry.LocateRegistry;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import net.openhft.chronicle.engine.api.management.mbean.AssetTreeDynamicMBean;
import net.openhft.chronicle.engine.api.map.MapEvent;
import net.openhft.chronicle.engine.api.map.SubscriptionKeyValueStore;
import net.openhft.chronicle.engine.api.tree.Asset;
import net.openhft.chronicle.engine.api.tree.AssetTree;
import net.openhft.chronicle.engine.map.ObjectKeyValueStore;
import net.openhft.chronicle.engine.map.ObjectSubscription;
import net.openhft.chronicle.engine.tree.HostIdentifier;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.network.api.session.SessionDetails;
import net.openhft.chronicle.network.api.session.SessionProvider;
import net.openhft.chronicle.threads.Threads;
import net.openhft.lang.thread.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ManagementTools {

    private static final Logger LOG = LoggerFactory.getLogger(ManagementTools.class);
    private static JMXConnectorServer jmxServer;
    @Nullable
    private static MBeanServer mbs;
    private static AssetTreeDynamicMBean dynamicMBean;
    private static int count;

    public static int getCount() {
        return count;
    }

    private static void startJMXRemoteService() throws IOException {
        if (jmxServer == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
            LocateRegistry.createRegistry(9000);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi:///jndi/rmi://localhost:9000/jmxrmi");
            HashMap<String, String> env = new HashMap<String, String>();
            env.put("com.sun.management.jmxremote", "true");
            env.put("com.sun.management.jmxremote.ssl", "false");
            env.put("com.sun.management.jmxremote.authenticate", "false");
            jmxServer = JMXConnectorServerFactory.newJMXConnectorServer(url, env, mbs);
            jmxServer.start();
        }
    }

    private static void stopJMXRemoteService() throws IOException {
        if (jmxServer != null) {
            mbs = null;
            jmxServer.stop();
        }
    }

    public static void enableManagement(@NotNull AssetTree assetTree) {
        try {
            ManagementTools.startJMXRemoteService();
            ++count;
        }
        catch (IOException ie) {
            LOG.error("Error while enable management", (Throwable)ie);
        }
        ManagementTools.registerViewofTree(assetTree);
    }

    public static void enableManagement(@NotNull AssetTree assetTree, int port) {
        try {
            ManagementTools.startJMXRemoteService();
            ++count;
        }
        catch (IOException ie) {
            LOG.error("Error while enable management", (Throwable)ie);
        }
        ManagementTools.registerViewofTree(assetTree);
    }

    public static void disableManagement(@NotNull AssetTree assetTree) {
        String treeName = assetTree.toString();
        try {
            Set<ObjectName> objNames = mbs.queryNames(new ObjectName("*:type=" + treeName + ",*"), null);
            objNames.forEach(atName -> ManagementTools.unregisterTreeWithMBean(atName));
        }
        catch (MalformedObjectNameException e) {
            LOG.error("Error while disable management", (Throwable)e);
        }
        --count;
        try {
            if (count == 0) {
                ManagementTools.stopJMXRemoteService();
            }
        }
        catch (IOException e) {
            LOG.error("Error while stopping JMX remote service", (Throwable)e);
        }
    }

    private static void registerViewofTree(@NotNull AssetTree tree) {
        Threads.withThreadGroup((ThreadGroup)tree.root().getView(ThreadGroup.class), () -> {
            ScheduledExecutorService ses = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("tree-watcher", Boolean.valueOf(true)));
            SessionProvider view = tree.root().findView(SessionProvider.class);
            SessionDetails sessionDetails = view.get();
            ses.submit(() -> {
                SessionProvider view0 = tree.root().findView(SessionProvider.class);
                view0.set(sessionDetails);
            });
            tree.registerSubscriber("", TopologicalEvent.class, e -> {
                if (e.assetName() != null) {
                    ses.schedule(() -> ManagementTools.handleTreeUpdate(tree, e, ses), 2000L, TimeUnit.MILLISECONDS);
                }
            });
            return null;
        });
    }

    private static void handleTreeUpdate(@NotNull AssetTree tree, @NotNull TopologicalEvent e, @NotNull ScheduledExecutorService ses) {
        try {
            HostIdentifier hostIdentifier = tree.root().getView(HostIdentifier.class);
            byte hostId = hostIdentifier == null ? (byte)0 : hostIdentifier.hostId();
            String treeName = tree.toString();
            if (e.added()) {
                Class c;
                String assetFullName = e.fullName();
                Asset asset = tree.getAsset(assetFullName);
                if (asset == null) {
                    return;
                }
                ObjectKeyValueStore view = null;
                Class[] classArray = new Class[]{ObjectKeyValueStore.class, SubscriptionKeyValueStore.class};
                int n = classArray.length;
                for (int i = 0; i < n && (view = (ObjectKeyValueStore)asset.getView(c = classArray[i])) == null; ++i) {
                }
                if (view == null) {
                    return;
                }
                ObjectKeyValueStore view0 = view;
                ObjectSubscription objectSubscription = asset.getView(ObjectSubscription.class);
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("size", "" + view.longSize());
                m.put("keyType", view.keyType().getName());
                m.put("valueType", view.valueType().getName());
                m.put("topicSubscriberCount", "" + objectSubscription.topicSubscriberCount());
                m.put("keySubscriberCount", "" + objectSubscription.keySubscriberCount());
                m.put("entrySubscriberCount", "" + objectSubscription.entrySubscriberCount());
                m.put("keyStoreValue", objectSubscription.getClass().getName());
                m.put("path", e.assetName() + "-" + e.name());
                for (int i = 0; i < view.segments(); ++i) {
                    view.entriesFor(i, entry -> {
                        if (entry.getValue().toString().length() > 256) {
                            m.put("~" + entry.getKey().toString(), entry.getValue().toString().substring(0, 256) + "...");
                        } else {
                            m.put("~" + entry.getKey().toString(), entry.getValue().toString());
                        }
                    });
                }
                dynamicMBean = new AssetTreeDynamicMBean(m);
                ObjectName atName = new ObjectName(ManagementTools.createObjectNameUri(hostId, e.assetName(), e.name(), treeName));
                ManagementTools.registerTreeWithMBean(dynamicMBean, atName);
                tree.registerSubscriber(e.fullName(), MapEvent.class, me -> ses.schedule(() -> ManagementTools.handleAssetUpdate(view0, atName, objectSubscription, e.assetName() + "-" + e.name()), 100L, TimeUnit.MILLISECONDS));
            } else {
                ObjectName atName = new ObjectName(ManagementTools.createObjectNameUri(hostId, e.assetName(), e.name(), treeName));
                ManagementTools.unregisterTreeWithMBean(atName);
            }
        }
        catch (Throwable t) {
            LOG.error("Error while handle AssetTree update", t);
        }
    }

    private static void handleAssetUpdate(@NotNull ObjectKeyValueStore view, ObjectName atName, @NotNull ObjectSubscription objectSubscription, String path) {
        try {
            if (mbs != null && mbs.isRegistered(atName)) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("size", "" + view.longSize());
                m.put("keyType", view.keyType().getName());
                m.put("valueType", view.valueType().getName());
                m.put("topicSubscriberCount", "" + objectSubscription.topicSubscriberCount());
                m.put("keySubscriberCount", "" + objectSubscription.keySubscriberCount());
                m.put("entrySubscriberCount", "" + objectSubscription.entrySubscriberCount());
                m.put("keyStoreValue", objectSubscription.getClass().getName());
                m.put("path", path);
                Iterator it = view.entrySetIterator();
                int i = 0;
                while ((long)i < view.longSize()) {
                    Map.Entry entry = it.next();
                    if (entry.getValue().toString().length() > 128) {
                        m.put("~" + entry.getKey().toString(), entry.getValue().toString().substring(0, 128) + "...");
                    } else {
                        m.put("~" + entry.getKey().toString(), entry.getValue().toString());
                    }
                    ++i;
                }
                dynamicMBean = new AssetTreeDynamicMBean(m);
                ManagementTools.unregisterTreeWithMBean(atName);
                ManagementTools.registerTreeWithMBean(dynamicMBean, atName);
            }
        }
        catch (Throwable t) {
            LOG.error("Error while handle Asset update", t);
        }
    }

    private static String createObjectNameUri(int hostId, @NotNull String assetName, String eventName, @NotNull String treeName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("treeName=" + treeName);
        }
        StringBuilder sb = new StringBuilder(256);
        sb.append("net.openhft.chronicle.engine:tree=");
        sb.append(hostId);
        sb.append(",type=");
        sb.append(treeName);
        String[] names = assetName.split("/");
        for (int i = 1; i < names.length; ++i) {
            sb.append(",side").append(i).append("=").append(names[i]);
        }
        sb.append(",name=").append(eventName);
        return sb.toString();
    }

    private static void registerTreeWithMBean(AssetTreeDynamicMBean atBean, ObjectName atName) {
        try {
            if (mbs != null && !mbs.isRegistered(atName)) {
                mbs.registerMBean(atBean, atName);
            }
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            LOG.error("Error register AssetTree with MBean", (Throwable)e);
        }
    }

    private static void unregisterTreeWithMBean(ObjectName atName) {
        try {
            if (mbs != null && mbs.isRegistered(atName)) {
                mbs.unregisterMBean(atName);
            }
        }
        catch (InstanceNotFoundException | MBeanRegistrationException e) {
            LOG.error("Error unregister AssetTree with MBean", (Throwable)e);
        }
    }

    private static String getMapAsString(@NotNull ObjectKeyValueStore view) {
        long max = view.longSize() - 1L;
        if (max == -1L) {
            return "{}";
        }
        StringBuilder sb = new StringBuilder();
        Iterator it = view.entrySetIterator();
        sb.append('{');
        int i = 0;
        while (true) {
            Map.Entry e = it.next();
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            sb.append(key);
            sb.append('=');
            if (value.length() > 128) {
                sb.append(value.substring(0, 128)).append("...");
            } else {
                sb.append(value);
            }
            if ((long)i == max) {
                return sb.append('}').toString();
            }
            sb.append(", ");
            ++i;
        }
    }

    static {
        mbs = null;
        count = 0;
    }
}

