/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import java.io.IOException;
import java.net.URISyntaxException;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.engine.api.management.mbean.ChronicleConfig;
import net.openhft.chronicle.engine.api.map.KeyValueStore;
import net.openhft.chronicle.engine.api.map.MapView;
import net.openhft.chronicle.engine.map.ChronicleMapKeyValueStore;
import net.openhft.chronicle.engine.map.VanillaMapView;
import net.openhft.chronicle.engine.server.ServerEndpoint;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.YamlLogging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleEngineMain {
    static final Logger LOGGER = LoggerFactory.getLogger(SimpleEngineMain.class);
    static final int HOST_ID = Integer.getInteger("engine.hostId", 0);
    static final boolean JMX = Boolean.getBoolean("engine.jmx");
    static final boolean PERSIST = Boolean.getBoolean("engine.persist");
    static final boolean MSG_DUMP = Boolean.getBoolean("engine.messages.dump");
    static final int PORT = Integer.getInteger("engine.port", 8088);
    static final WireType WIRE_TYPE = WireType.valueOf((String)System.getProperty("engine.wireType", "BINARY"));
    static ServerEndpoint serverEndpoint;

    public static void main(String ... args) throws IOException, InterruptedException, URISyntaxException {
        ChronicleConfig.init();
        VanillaAssetTree assetTree = new VanillaAssetTree(HOST_ID).forTesting(false, t -> t.printStackTrace());
        if (JMX) {
            assetTree.enableManagement();
        }
        assetTree.registerSubscriber("", TopologicalEvent.class, e -> LOGGER.info("Tree change ", e));
        if (PERSIST) {
            LOGGER.info("Persistence enabled");
            assetTree.root().addWrappingRule(MapView.class, "map directly to KeyValueStore", VanillaMapView::new, KeyValueStore.class);
            assetTree.root().addLeafRule(KeyValueStore.class, "use Chronicle Map", (context, asset) -> new ChronicleMapKeyValueStore(context.basePath(OS.TARGET), asset));
        }
        serverEndpoint = new ServerEndpoint("*:" + PORT, assetTree, WIRE_TYPE);
        if (MSG_DUMP) {
            LOGGER.info("Enabling message logging");
            YamlLogging.setAll((boolean)true);
        }
        LOGGER.info("Server port seems to be " + PORT);
    }
}

