/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.engine;

import java.io.IOException;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.engine.api.management.mbean.ChronicleConfig;
import net.openhft.chronicle.engine.cfg.ChronicleMapCfg;
import net.openhft.chronicle.engine.cfg.ClustersCfg;
import net.openhft.chronicle.engine.cfg.EngineCfg;
import net.openhft.chronicle.engine.cfg.FilePerKeyMapCfg;
import net.openhft.chronicle.engine.cfg.InMemoryMapCfg;
import net.openhft.chronicle.engine.cfg.Installable;
import net.openhft.chronicle.engine.cfg.JmxCfg;
import net.openhft.chronicle.engine.cfg.MonitorCfg;
import net.openhft.chronicle.engine.cfg.ServerCfg;
import net.openhft.chronicle.engine.tree.TopologicalEvent;
import net.openhft.chronicle.engine.tree.VanillaAssetTree;
import net.openhft.chronicle.wire.TextWire;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EngineMain {
    static final Logger LOGGER = LoggerFactory.getLogger(EngineMain.class);
    static final int HOST_ID = Integer.getInteger("engine.hostId", 0);

    static <I extends Installable> void addClass(Class<I> ... iClasses) {
        ClassAliasPool.CLASS_ALIASES.addAlias((Class[])iClasses);
    }

    public static void main(String[] args) throws IOException {
        ChronicleConfig.init();
        EngineMain.addClass(EngineCfg.class);
        EngineMain.addClass(JmxCfg.class);
        EngineMain.addClass(ServerCfg.class);
        EngineMain.addClass(ClustersCfg.class);
        EngineMain.addClass(InMemoryMapCfg.class);
        EngineMain.addClass(FilePerKeyMapCfg.class);
        EngineMain.addClass(ChronicleMapCfg.class);
        EngineMain.addClass(MonitorCfg.class);
        String name = args.length > 0 ? args[0] : "engine.yaml";
        TextWire yaml = TextWire.fromFile((String)name);
        Installable installable = (Installable)yaml.readObject();
        VanillaAssetTree assetTree = new VanillaAssetTree(HOST_ID).forServer(false, Throwable::printStackTrace);
        assetTree.registerSubscriber("", TopologicalEvent.class, e -> LOGGER.info("Tree change " + e));
        try {
            installable.install("/", assetTree);
            LOGGER.info("Engine started");
        }
        catch (Exception e2) {
            LOGGER.error("Error starting a component, stopping", (Throwable)e2);
            assetTree.close();
        }
    }
}

