/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.scoped;

import java.lang.ref.WeakReference;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.scoped.AbstractScopedResource;
import net.openhft.chronicle.core.scoped.ScopedThreadLocal;
import org.jetbrains.annotations.Nullable;

public class WeakReferenceScopedResource<T>
extends AbstractScopedResource<T> {
    private final Supplier<T> supplier;
    private WeakReference<T> ref;
    private T strongRef;

    public WeakReferenceScopedResource(ScopedThreadLocal<T> scopedThreadLocal, Supplier<T> supplier) {
        super(scopedThreadLocal);
        this.supplier = supplier;
    }

    @Override
    void preAcquire() {
        if (this.ref == null || (this.strongRef = this.ref.get()) == null) {
            this.strongRef = this.supplier.get();
            this.ref = new WeakReference<T>(this.strongRef);
        }
    }

    @Override
    public T get() {
        return this.strongRef;
    }

    @Override
    public void close() {
        this.strongRef = null;
        super.close();
    }

    @Override
    public void closeResource() {
        if (this.ref != null) {
            Closeable.closeQuietly(this.ref.get());
            this.ref.clear();
            this.ref = null;
        }
    }

    @Override
    @Nullable
    public Class<?> getType() {
        Object val = this.ref != null ? (Object)this.ref.get() : null;
        return val != null ? val.getClass() : null;
    }
}

