/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.core.internal;

import java.util.Collections;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.AbstractReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.util.WeakIdentityHashMap;

public final class ReferenceCountedUtils {
    private static final AtomicReference<Set<AbstractReferenceCounted>> REFERENCE_COUNTED_SET = new AtomicReference();

    private ReferenceCountedUtils() {
    }

    public static void add(AbstractReferenceCounted referenceCounted) {
        Set<AbstractReferenceCounted> set = REFERENCE_COUNTED_SET.get();
        if (set != null) {
            set.add(referenceCounted);
        }
    }

    public static void enableReferenceTracing() {
        AbstractCloseable.enableCloseableTracing();
        REFERENCE_COUNTED_SET.set(Collections.synchronizedSet(Collections.newSetFromMap(new WeakIdentityHashMap())));
    }

    public static void disableReferenceTracing() {
        AbstractCloseable.disableCloseableTracing();
        REFERENCE_COUNTED_SET.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void assertReferencesReleased() {
        Set<AbstractReferenceCounted> traceSet = REFERENCE_COUNTED_SET.get();
        if (traceSet == null) {
            Jvm.warn().on(ReferenceCountedUtils.class, "Reference tracing disabled");
            return;
        }
        AbstractCloseable.assertCloseablesClosed();
        AssertionError openFiles = new AssertionError((Object)"Reference counted not released");
        Set<AbstractReferenceCounted> set = traceSet;
        synchronized (set) {
            for (AbstractReferenceCounted key : traceSet) {
                if (key == null || key.refCount() == 0) continue;
                try {
                    key.throwExceptionIfNotReleased();
                }
                catch (Exception e) {
                    ((Throwable)((Object)openFiles)).addSuppressed(e);
                }
            }
        }
        if (((Throwable)((Object)openFiles)).getSuppressed().length > 0) {
            throw openFiles;
        }
    }

    public static void unmonitor(ReferenceCounted counted) {
        Set<AbstractReferenceCounted> set = REFERENCE_COUNTED_SET.get();
        if (counted instanceof AbstractReferenceCounted) {
            if (set != null) {
                set.remove(counted);
            }
            ((AbstractReferenceCounted)counted).referenceCountedUnmonitored(true);
        }
    }
}

