/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.bytes;

import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.bytes.internal.NativeBytesStore;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.annotation.NonNegative;
import org.jetbrains.annotations.NotNull;

public class PointerBytesStore
extends NativeBytesStore<Void> {
    public PointerBytesStore() {
        super(NoBytesStore.NO_PAGE, 0L, null, false, false);
    }

    public void set(long address, @NonNegative long capacity) {
        this.setAddress(address);
        this.limit = this.maximumLimit = capacity;
        if (capacity == 0x7FFFFFFFFFFFFFF0L) {
            Jvm.warn().on(this.getClass(), "the provided capacity of underlying looks like it may have come from an elastic bytes, please make sure you do not use PointerBytesStore with ElasticBytes since the address of the underlying store may change once it expands");
        }
    }

    @Override
    @NotNull
    public VanillaBytes<Void> bytesForWrite() throws IllegalStateException {
        try {
            return new VanillaBytes<Void>((BytesStore)this, 0L, 0x7FFFFFFFFFFFFFF0L);
        }
        catch (IllegalArgumentException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    @NonNegative
    public long safeLimit() {
        return this.limit;
    }

    @Override
    @NonNegative
    public long start() {
        return 0L;
    }
}

