/*
 * Decompiled with CFR 0.152.
 */
package net.masterthought.cucumber.json.deserializers;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.masterthought.cucumber.Configuration;
import net.masterthought.cucumber.ValidationException;
import net.masterthought.cucumber.json.Embedding;
import net.masterthought.cucumber.json.deserializers.CucumberJsonDeserializer;
import org.codehaus.plexus.util.Base64;

public class EmbeddingDeserializer
extends CucumberJsonDeserializer<Embedding> {
    @Override
    public Embedding deserialize(JsonParser parser, Configuration configuration) throws IOException {
        JsonNode rootNode = (JsonNode)parser.getCodec().readTree(parser);
        String data = rootNode.get("data").asText();
        String mimeType = rootNode.get("mime_type").asText();
        Embedding embedding = new Embedding(mimeType, data);
        this.storeEmbedding(embedding, configuration);
        return embedding;
    }

    private void storeEmbedding(Embedding embedding, Configuration configuration) {
        Path file = FileSystems.getDefault().getPath(configuration.getEmbeddingDirectory().getAbsolutePath(), embedding.getFileId() + "." + embedding.getExtension());
        try {
            Files.write(file, Base64.decodeBase64((byte[])embedding.getData().getBytes(StandardCharsets.UTF_8)), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new ValidationException(e);
        }
    }
}

