/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.opentype.TtfInstructions.instructions.graphic;

import java.io.IOException;
import org.mabb.fontverter.io.FontDataInputStream;
import org.mabb.fontverter.opentype.TtfInstructions.InstructionStack;
import org.mabb.fontverter.opentype.TtfInstructions.TtfVirtualMachine;
import org.mabb.fontverter.opentype.TtfInstructions.instructions.TtfInstruction;

public class SetZonePointerSInstruction
extends TtfInstruction {
    @Override
    public int[] getCodeRanges() {
        return new int[]{22};
    }

    @Override
    public void read(FontDataInputStream in) throws IOException {
    }

    @Override
    public void execute(InstructionStack stack) throws IOException {
        Long zone;
        Number zoneObj = stack.popNumber();
        if (!(zoneObj instanceof Long)) {
            log.warn("SetZonePointer Expected Uint32 but was int");
        }
        if ((zone = Long.valueOf(zoneObj.longValue())) > 1L) {
            throw new TtfVirtualMachine.TtfVmRuntimeException("SetZonePointerS popped zone number must 0 (twilight zone) or 1 (glyph zone)");
        }
        this.vm.getGraphicsState().zone0Id = zone;
        this.vm.getGraphicsState().zone1Id = zone;
        this.vm.getGraphicsState().zone2Id = zone;
    }
}

