/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.io;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import org.mabb.fontverter.FontVerterUtils;
import org.mabb.fontverter.io.DataTypeProperty;
import org.mabb.fontverter.io.DataTypeSerializerException;

class DataTypeAnnotationReader {
    public List<AccessibleObject> getProperties(Class type) throws DataTypeSerializerException {
        LinkedList<AccessibleObject> properties = new LinkedList<AccessibleObject>();
        for (Field field : type.getDeclaredFields()) {
            if (!field.isAnnotationPresent(DataTypeProperty.class)) continue;
            field.setAccessible(true);
            properties.add(field);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            if (!accessibleObject.isAnnotationPresent(DataTypeProperty.class)) continue;
            ((Method)accessibleObject).setAccessible(true);
            properties.add(accessibleObject);
        }
        for (AccessibleObject propertyOn : properties) {
            DataTypeProperty annotationOn = this.getPropertyAnnotation(propertyOn);
            boolean bl = annotationOn.dataType() == DataTypeProperty.DataType.BYTE_ARRAY || annotationOn.dataType() == DataTypeProperty.DataType.STRING;
            if (!bl || annotationOn.constLength() >= 1) continue;
            throw new DataTypeSerializerException("byteLength annotation field is required for " + (Object)((Object)annotationOn.dataType()));
        }
        this.sortProperties(properties);
        return properties;
    }

    public boolean isIgnoreProperty(DataTypeProperty property, Object object) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String ignoreIf = property.ignoreIf();
        if (!ignoreIf.isEmpty()) {
            return this.runIgnoreFilter(object, ignoreIf);
        }
        String includeIf = property.includeIf();
        if (!includeIf.isEmpty()) {
            return !this.runIgnoreFilter(object, includeIf);
        }
        return false;
    }

    public int getPropertyArrayLength(DataTypeProperty property, Object object) throws NoSuchFieldException, IllegalAccessException, InvocationTargetException {
        Field field = FontVerterUtils.findPrivateField(property.arrayLength(), object.getClass());
        if (field != null) {
            return (int)field.getLong(object);
        }
        Method method = FontVerterUtils.findPrivateMethod(property.arrayLength(), object.getClass());
        return ((Number)method.invoke(object, new Object[0])).intValue();
    }

    private boolean runIgnoreFilter(Object object, String ignoreIf) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        if (ignoreIf.isEmpty()) {
            return false;
        }
        boolean hasNotOperator = false;
        if (ignoreIf.startsWith("!")) {
            hasNotOperator = true;
            ignoreIf = ignoreIf.replace("!", "");
        }
        boolean filterResult = false;
        List<Boolean> originalAccessibility = DataTypeAnnotationReader.setAllPropertiesAccessible(object.getClass());
        Object fieldResult = this.tryGetFieldValue(ignoreIf, object);
        if (fieldResult == null) {
            Method method = object.getClass().getMethod(ignoreIf.replace("()", ""), new Class[0]);
            filterResult = (Boolean)method.invoke(object, new Object[0]);
        }
        if (hasNotOperator) {
            filterResult = !filterResult;
        }
        DataTypeAnnotationReader.resetAccessibility(originalAccessibility, object.getClass());
        return filterResult;
    }

    private Object tryGetFieldValue(String fieldName, Object object) throws IllegalAccessException {
        try {
            Field field = object.getClass().getField(fieldName);
            return field.get(object);
        }
        catch (NoSuchFieldException e) {
            return null;
        }
    }

    private void sortProperties(List<AccessibleObject> properties) throws DataTypeSerializerException {
        boolean hasorder = false;
        for (AccessibleObject propOn : properties) {
            if (this.getPropertyAnnotation(propOn).order() == -1) continue;
            hasorder = true;
        }
        if (!hasorder) {
            return;
        }
        Collections.sort(properties, new Comparator<Object>(){

            @Override
            public int compare(Object obj1, Object obj2) {
                try {
                    int order1 = DataTypeAnnotationReader.this.getPropertyAnnotation(obj1).order();
                    int order2 = DataTypeAnnotationReader.this.getPropertyAnnotation(obj2).order();
                    return order1 < order2 ? -1 : (order1 == order2 ? 0 : 1);
                }
                catch (DataTypeSerializerException e) {
                    return 0;
                }
            }
        });
    }

    private DataTypeProperty getPropertyAnnotation(Object property) throws DataTypeSerializerException {
        if (property instanceof Field) {
            return ((Field)property).getAnnotation(DataTypeProperty.class);
        }
        if (property instanceof Method) {
            return ((Method)property).getAnnotation(DataTypeProperty.class);
        }
        throw new DataTypeSerializerException("Could not find annotation for property " + property.toString());
    }

    private static List<Boolean> setAllPropertiesAccessible(Class type) {
        LinkedList<Boolean> originalAccessiblity = new LinkedList<Boolean>();
        for (Field field : type.getDeclaredFields()) {
            originalAccessiblity.add(field.isAccessible());
            field.setAccessible(true);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            originalAccessiblity.add(accessibleObject.isAccessible());
            ((Method)accessibleObject).setAccessible(true);
        }
        return originalAccessiblity;
    }

    private static void resetAccessibility(List<Boolean> originalAccessibility, Class type) {
        int i = 0;
        for (Field field : type.getDeclaredFields()) {
            field.setAccessible(originalAccessibility.get(i));
            ++i;
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            ((Method)accessibleObject).setAccessible(originalAccessibility.get(i));
            ++i;
        }
    }
}

