/*
 * Decompiled with CFR 0.152.
 */
package org.mabb.fontverter.converter;

import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import org.mabb.fontverter.FVFont;
import org.mabb.fontverter.converter.FontConverter;
import org.mabb.fontverter.opentype.OpenTypeFont;
import org.mabb.fontverter.opentype.OpenTypeTable;
import org.mabb.fontverter.woff.WoffFont;
import org.mabb.fontverter.woff.WoffTable;

public class WoffToOtfConverter
implements FontConverter {
    OpenTypeFont otfFont;
    WoffFont woffFont;

    @Override
    public FVFont convertFont(FVFont font) throws IOException {
        this.woffFont = (WoffFont)font;
        this.otfFont = new OpenTypeFont();
        try {
            this.readTables();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        this.otfFont.finalizeFont();
        return this.otfFont;
    }

    private void readTables() throws IOException, InstantiationException, IllegalAccessException {
        for (WoffTable woffTable : this.woffFont.getTables()) {
            OpenTypeTable.OtfTableRecord record = new OpenTypeTable.OtfTableRecord();
            record.recordName = woffTable.getTag();
            if (record.recordName.length() < 4) {
                record.recordName = record.recordName + StringUtils.repeat((String)" ", (int)(4 - record.recordName.length()));
            }
            record.originalData = woffTable.getTableData();
            OpenTypeTable table = OpenTypeTable.createFromRecord(record, this.otfFont);
            table.isFromParsedFont = true;
            this.otfFont.addTable(table);
        }
        this.otfFont.orderTablesByDependencies();
        for (OpenTypeTable openTypeTable : this.otfFont.getTables()) {
            openTypeTable.readData(openTypeTable.record.originalData);
        }
    }
}

